import type { editor as monacoEditor } from 'monaco-editor';

export const getYamlEditorOptions: () => monacoEditor.IStandaloneEditorConstructionOptions = () => ({
    contextmenu: false,
    folding: true,
    fontFamily: 'var(--yc-font-family-monospace, monospace)',
    fontSize: 13,
    lineHeight: 18,
    lineNumbers: 'on',
    minimap: { enabled: true },
    occurrencesHighlight: false,
    renderLineHighlight: 'none',
    scrollbar: {
        horizontal: 'auto',
        horizontalScrollbarSize: 10,
        vertical: 'auto',
        verticalScrollbarSize: 10,
    },
    suggest: {
        showIcons: true,
        preview: true,
        previewMode: 'subword',
        insertMode: 'replace',
        showInlineDetails: false,
    },
    suggestLineHeight: 26,
    wordBasedSuggestions: false,
    wordWrap: 'bounded',
    wordWrapColumn: 120,
    quickSuggestionsDelay: 100,
});
