export const namedColors = {
    code: {
        herbalGreen: '#638d00',
        lightGreen: '#98c379',
        green: '#07a300',
        darkOrange: '#b36b00',
        lightOrange: '#d19a66',
        lightYellow: '#e6c07b',
        lightRed: '#e06c75',
        violet: '#9a32a6',
        lightViolet: '#c678dd',
        blue: '#026cd6',
        lightBlue: '#61aeee',
        black: '#000000',
        lightGray: '#a5a5a5',
        blueGray: '#708090',
        softWhite: '#ffffffd9',
        softBlack: '#000000d9',
    },
    infracloud: {
        dark: {
            text: '#ffffffd9',
            background: '#2d2c33',
        },
        light: {
            text: '#000000',
            background: '#ffffff',
        },
    },
} as const;

const splitByCase = (str: string) => str.replace(/([a-z])([A-Z])/g, '$1.$2').split('.');

type Tree = {
    [key: string]: string | Tree;
};

function getCssProperties(tree: Tree, prefix = ''): Record<string, string> {
    let result: Record<string, string> = {};

    for (const [key, value] of Object.entries(tree)) {
        const currentPrefix = `${prefix}-${splitByCase(key).join('-').toLowerCase()}`;
        if (typeof value === 'string') {
            result[currentPrefix] = value;
            continue;
        }

        result = Object.assign(result, getCssProperties(value, currentPrefix));
    }

    return result;
}

const cssProperties = getCssProperties(namedColors, '--color');

export const namedColorsEnvStyle = Object.entries(cssProperties)
    .map(([name, value]) => `${name}: ${value};`)
    .join('\n');

export const colorsRootCss = `:root {${namedColorsEnvStyle}}`;
