import type { editor } from 'monaco-editor/esm/vs/editor/editor.api';

import { namedColors } from './colors';

export const infracloudMonacoThemes = {
    light: 'infracloud-ui',
    dark: 'infracloud-ui-dark',
};

// yaml tokens https://github.com/microsoft/monaco-editor/blob/main/src/basic-languages/yaml/yaml.ts

export const infracloudUILightThemeData: editor.IStandaloneThemeData = {
    base: 'vs',
    colors: {
        // https://code.visualstudio.com/api/references/theme-color
        'foreground': namedColors.infracloud.light.text,
        'editor.foreground': namedColors.infracloud.light.text,
        'editor.background': namedColors.infracloud.light.background,
        'input.foreground': namedColors.infracloud.light.text,
        'input.background': namedColors.infracloud.light.background,
        'editorWidget.foreground': namedColors.infracloud.light.text,
        'editorWidget.background': namedColors.infracloud.light.background,
        'editorLineNumber.foreground': namedColors.code.lightGray,
        'editorLineNumber.activeForeground': namedColors.code.black,
    },
    inherit: true,
    rules: [
        {
            token: 'string',
            foreground: namedColors.code.herbalGreen,
        },
        {
            token: 'string.yaml',
            foreground: namedColors.code.herbalGreen,
        },
        {
            token: 'number',
            foreground: namedColors.code.darkOrange,
        },
        {
            token: 'comment',
            foreground: namedColors.code.blueGray,
        },
        {
            token: 'constant.numeric',
            foreground: namedColors.code.darkOrange,
        },
        {
            token: 'entity.name.tag',
            foreground: namedColors.code.blue,
        },
        {
            token: 'type.yaml', // keys in objects
            foreground: namedColors.code.blue,
        },
        {
            token: 'constant.language.boolean',
            foreground: namedColors.code.violet,
        },
        {
            token: 'keyword.yaml',
            foreground: namedColors.code.violet,
        },
        {
            token: 'keyword',
            foreground: namedColors.code.violet,
        },
        {
            token: 'entity.name.function',
            foreground: namedColors.code.blue,
        },
    ],
};

export const infracloudUIDarkThemeData: editor.IStandaloneThemeData = {
    base: 'vs-dark',
    colors: {
        // https://code.visualstudio.com/api/references/theme-color
        'foreground': namedColors.infracloud.dark.text,
        'editor.foreground': namedColors.infracloud.dark.text,
        'editor.background': namedColors.infracloud.dark.background,
        'input.foreground': namedColors.infracloud.dark.text,
        'input.background': namedColors.infracloud.dark.background,
        'editorWidget.foreground': namedColors.infracloud.dark.text,
        'editorWidget.background': namedColors.infracloud.dark.background,
        'editorLineNumber.foreground': namedColors.code.lightGray,
        'editorLineNumber.activeForeground': namedColors.code.softWhite,
    },
    inherit: true,
    rules: [
        {
            token: 'string',
            foreground: namedColors.code.lightGreen,
        },
        {
            token: 'string.yaml',
            foreground: namedColors.code.lightGreen,
        },
        {
            token: 'number',
            foreground: namedColors.code.lightOrange,
        },
        {
            token: 'comment',
            foreground: namedColors.code.blueGray,
        },
        {
            token: 'constant.numeric',
            foreground: namedColors.code.lightOrange,
        },
        {
            token: 'entity.name.tag',
            foreground: namedColors.code.blue,
        },
        {
            token: 'type.yaml', // keys in objects
            foreground: namedColors.code.lightBlue,
        },
        {
            token: 'constant.language.boolean',
            foreground: namedColors.code.lightViolet,
        },
        {
            token: 'keyword.yaml',
            foreground: namedColors.code.lightViolet,
        },
        {
            token: 'keyword',
            foreground: namedColors.code.lightViolet,
        },
        {
            token: 'entity.name.function',
            foreground: namedColors.code.lightBlue,
        },
    ],
};
