import type { editor as monacoEditor, IDisposable } from 'monaco-editor/esm/vs/editor/editor.api';

export class PlaceholderWidget implements monacoEditor.IContentWidget {
    private readonly placeholder: string;

    private editor: monacoEditor.IStandaloneCodeEditor;

    private toDispose: IDisposable[];

    constructor(placeholder: string, editor: monacoEditor.IStandaloneCodeEditor) {
        this.placeholder = placeholder;
        this.editor = editor;

        this.toDispose = [];

        this.toDispose.push(editor.onDidChangeModelContent(() => this.onDidChangeModelContent()));
        this.onDidChangeModelContent();
    }

    getId(): string {
        return `editor.widget.placeholder.custom`;
    }

    getDomNode(): HTMLElement {
        const content = document.createElement('div');
        content.textContent = this.placeholder;
        content.style.width = 'max-content';
        content.style.color = 'var(--vscode-editor-foreground, gray)';
        content.style.opacity = '0.3';

        return content;
    }

    getPosition(): monacoEditor.IContentWidgetPosition | null {
        return {
            position: { lineNumber: 1, column: 1 },
            preference: [0],
        };
    }

    dispose(): void {
        this.editor.removeContentWidget(this);
        this.toDispose.forEach(e => e.dispose());
    }

    private onDidChangeModelContent(): void {
        if (this.editor.getValue() === '') {
            this.editor.addContentWidget(this);
        } else {
            this.editor.removeContentWidget(this);
        }
    }
}
