import type { editor } from 'monaco-editor/esm/vs/editor/editor.api';

import { infracloudMonacoThemes, infracloudUIDarkThemeData, infracloudUILightThemeData } from '../models';
import { importMonacoApi } from './lazyModules';

export function defineInfracloudMonacoThemesSync(editorApi: typeof editor) {
    editorApi.defineTheme(infracloudMonacoThemes.light, infracloudUILightThemeData);
    editorApi.defineTheme(infracloudMonacoThemes.dark, infracloudUIDarkThemeData);
    editorApi.setTheme(infracloudMonacoThemes.light);
}

export async function defineInfracloudMonacoThemes() {
    const { editor } = await importMonacoApi();

    defineInfracloudMonacoThemesSync(editor);
}
