export function memoAsyncEffect<T extends () => Promise<any>>(f: T): T {
    let result: ReturnType<T> | null = null;
    let exist = false;
    return (async () => {
        if (!exist) {
            result = await f();
            exist = true;
        }
        return result;
    }) as T;
}
