import babel from "rollup-plugin-babel";
import resolve from "rollup-plugin-node-resolve";
import typescript from "rollup-plugin-typescript";
import commonjs from "rollup-plugin-commonjs";

export default {
    input: "./src/index.ts",
    external: ["rxjs"],

    output: [
        {
            format: "umd",
            name: "yasmStats",
            file: "./dist/index.js",
            sourcemap: true,
            exports: "named",
            globals: {
                rxjs: "rxjs"
            }
        }
    ],

    plugins: [
        typescript(),
        resolve(),
        babel({
            runtimeHelpers: true,
            presets: ["@babel/preset-env"]
        }),
        commonjs({
            include: ["node_modules/**"]
        })
    ]
};
