import {isNumber} from './utils';

export class Counter {
    private aggregationType: string;
    private value: number;

    constructor(aggregationType: string = 'summ', value: number = 0) {
        this.aggregationType = aggregationType;
        this.value = value;
    }

    add(...values: number[]) {
        for (const value of values) {
            if (!isNumber(value)) {
                continue;
            }

            this.value += value;
        }
    }

    set(value: number) {
        this.value = value;
    }

    getYasmFormat() {
        return [this.aggregationType, this.value];
    }
}
