import {isNumber} from './utils';

export class Histogram {
    private values: number[] = [];

    add(...values: number[]) {
        for (const value of values) {
            if (!isNumber(value)) {
                continue;
            }

            this.values.push(value);
        }
    }

    getYasmFormat() {
        return ['hhhh', this.values];
    }
}
