import { isFunction } from '../utils';
const TAG_REGEXP = /^[a-zA-Z0-9-@.*_]{1,128}$/;
const SIGNAL_REGEXP = /^[a-zA-Z0-9._/@]{1,120}$/;

function tagTest(value: string) {
    return typeof value === 'string' && TAG_REGEXP.test(value);
}

function signalTest(value: string) {
    return typeof value === 'string' && SIGNAL_REGEXP.test(value);
}

function decorate(f: any) {
    return function(this: any, ...args: any[]) {
        if (args.length === 2 && isFunction(args[1].value)) {
            const descriptors = args[1];
            const original = descriptors.value;

            descriptors.value = function(this: any, name: string) {
                if (!signal(name)) {
                    return;
                }

                return original.apply(this, arguments);
            };

            return descriptors;
        } else {
            return f.apply(this, arguments);
        }
    };
}

export const signal = decorate(signalTest);
export const tag = decorate(tagTest);
