import { Observable } from 'rxjs';

const ajaxError = new Observable<number>(observer => {
    const prevOpen = XMLHttpRequest.prototype.open;

    XMLHttpRequest.prototype.open = function(this: any) {
        this.addEventListener('error', () => {
            observer.next(this.status);
        });
        // @ts-ignore
        return prevOpen.apply(this, arguments);
    };
});

export default {
    install(statsManager: any) {
        ajaxError.subscribe(status => {
            statsManager.incrementCounter('requests.failed.count', 'mmmm');

            if (status >= 500) {
                statsManager.incrementCounter('requests.5xx.count', 'mmmm');
            } else if (status >= 400) {
                statsManager.incrementCounter('requests.4xx.count', 'mmmm');
            }
        });
    }
};
