import { Observable } from 'rxjs';

const ajaxInprogress = new Observable<number>(observer => {
    let value = 0;

    const prevOpen = XMLHttpRequest.prototype.open;
    const prevFetch = fetch;

    XMLHttpRequest.prototype.open = function(this: any) {
        this.addEventListener('loadstart', () => {
            observer.next(++value);
        });
        this.addEventListener('loadend', () => {
            value = Math.max(0, value - 1);
            observer.next(value);
        });
        // @ts-ignore
        return prevOpen.apply(this, arguments);
    };

    // @ts-ignore
    fetch = function(this: any) {
        observer.next(++value);
        const result = prevFetch.apply(this, arguments);

        result.then(
            () => {
                value = Math.max(0, value - 1);
                observer.next(value);
            },
            () => {
                value = Math.max(0, value - 1);
                observer.next(value);
            }
        );

        return result;
    };
});

export default {
    install(statsManager: any) {
        ajaxInprogress.subscribe(value => {
            statsManager.addSample('requests.inprogress.count', value);
        });
    }
};
