import {Observable} from 'rxjs';

const exceptions = new Observable<void>(observer => {
    window.addEventListener('error', () => {
        observer.next();
    });

    window.addEventListener('unhandledrejection', () => {
        observer.next();
    });
});

export default {
    install(statsManager: any) {
        exceptions.subscribe(value => {
            statsManager.incrementCounter('errors.count', 'mmmm', value);
        });
    },
};
