import {interval} from 'rxjs';

const NETWORK_STAT_INTERVAL = 5e3;
const EFFECTIVE_TYPES = new Map([['4g', '4g'], ['3g', '3g'], ['2g', '2g'], ['2g-slow', 'dialup']]);

declare var navigator: any;

function isNavigatorConnectionSupport() {
    return navigator && !!navigator.connection;
}

const network = interval(NETWORK_STAT_INTERVAL);

function connectionName(effectiveType: string) {
    if (!EFFECTIVE_TYPES.has(effectiveType)) {
        return 'unknown';
    }

    return EFFECTIVE_TYPES.get(effectiveType);
}

export default {
    install(statsManager: any) {
        if (!isNavigatorConnectionSupport()) {
            return; // INFO: For network monitoring use browser with navigator.connection support
        }

        network.subscribe(() => {
            const {downlink, effectiveType, rtt} = navigator.connection;

            statsManager.addSample('performance.network.rtt', rtt);
            statsManager.addSample('performance.network.downlink', downlink);
            statsManager.setCounterValue('performance.network.' + connectionName(effectiveType), 'mmmm', 1);
        });
    },
};
