import {Observable} from 'rxjs';

function getVisibility() {
    return document.visibilityState;
}

const visibility = new Observable<string>(observer => {
    document.addEventListener('visibilitychange', () => {
        observer.next(getVisibility());
    });
});

export default {
    install(statsManager) {
        statsManager.setVisibility(getVisibility());

        visibility.subscribe(value => {
            statsManager.setVisibility(value);
        });
    },
};
