import decorate from './lib/decorate';
import signalName from './lib/signalName';

let ajax = (f: any, statsManager: any, name: any) => {
    return function(this: any) {
        const before = performance.now();
        const result = f.apply(this, arguments);

        const signal = signalName(name, this);

        if (!result || !result.then) {
            return result;
        }

        result.then(
            () => {
                const now = performance.now();
                statsManager.addSample(`${signal}.time`, Math.ceil(now - before));
                statsManager.incrementCounter(`${signal}.200.count`, 'mmmm');
            },
            (xhr: any) => {
                const now = performance.now();

                statsManager.incrementCounter(`${signal}.failure.count`, 'mmmm');
                statsManager.addSample(`${signal}.failure.time`, Math.ceil(now - before));

                if (!xhr) {
                    return;
                }

                if (xhr.statusText === 'timeout') {
                    statsManager.incrementCounter(`${signal}.timeout.count`, 'mmmm');
                }

                if (xhr.status >= 500) {
                    statsManager.incrementCounter(`${signal}.5xx.count`, 'mmmm');
                } else if (xhr.status >= 400) {
                    statsManager.incrementCounter(`${signal}.4xx.count`, 'mmmm');
                }
            },
        );

        return result;
    };
};

function mock(f: any) {
    return function(this: any) {
        return f.apply(this, arguments);
    };
}

if (!performance || !performance.now) {
    // INFO: For monitoring with ajax helper use browser with performance.now support
    ajax = mock;
}

export default function(statsManager: any, ...args: any[]) {
    return decorate(ajax, statsManager, ...args);
}
