import decorate from './lib/decorate';
import signalName from './lib/signalName';

let execution = (f: any, statsManager: any, name: string) => {
    return function(this: any) {
        const before = performance.now();
        const result = f.apply(this, arguments);
        const now = performance.now();

        const signal = signalName(name, this);

        statsManager.addSample(`${signal}.time`, Math.ceil(now - before));
        return result;
    };
};

function mock(f: any) {
    return function(this: any) {
        return f.apply(this, arguments);
    };
}

if (!performance || !performance.now) {
    // INFO: For monitoring with execution helper use browser with performance.now support
    execution = mock;
}

export default function(statsManager: any, ...args: any[]) {
    return decorate(execution, statsManager, ...args);
}
