import decorate from './lib/decorate';
import IntervalState from './lib/IntervalState';
import signalName from './lib/signalName';

const states = new WeakMap();

function _getState(target: any) {
    if (target && !states.has(target)) {
        states.set(target, new IntervalState());
    }

    return states.get(target);
}

function _deleteState(target: any) {
    states.delete(target);
}

let interval = (f: any, statsManager: any, name: any) => {
    function reset(target: any, base: any) {
        _getState(target).reset(base);
    }

    function cancel(target: any) {
        _deleteState(target);
    }

    function wrapper(this: any) {
        const now = performance.now();
        const result = f.apply(this, arguments);

        const state = _getState(this);
        state.next(now);

        if (state.isValid()) {
            const signal = signalName(name, this);
            const value = state.getValue();

            statsManager.addSample(`${signal}.time`, Math.floor(value));
        }

        return result;
    }

    wrapper.reset = reset;
    wrapper.cancel = cancel;

    return wrapper;
};

function mock(f: any) {
    function wrapper(this: any) {
        return f.apply(this, arguments);
    }

    wrapper.reset = () => {
        /*mock*/
    };
    wrapper.cancel = () => {
        /*mock*/
    };

    return wrapper;
}

if (!performance || !performance.now) {
    // INFO: For monitoring with interval helper use browser with performance.now support
    interval = mock;
}

export default function(statsManager: any, ...args: any[]) {
    return decorate(interval, statsManager, ...args);
}
