import {isNumber} from '../../utils';

export default class IntervalState {
    private prev?: number;
    private last?: number;
    private base?: number;

    next(value: number) {
        this.prev = this.last;
        this.last = value;
    }

    isValid() {
        return this.prev !== undefined;
    }

    getValue() {
        const [last = 0, prev = 0, base = 0] = [this.last, this.prev, this.base];

        let value = last - prev;

        if (base) {
            value = Math.abs(base - value);
        }

        return value;
    }

    reset(base: number) {
        this.prev = undefined;
        this.last = undefined;

        if (isNumber(base)) {
            this.base = base;
        }
    }
}
