import {StatsManager} from '../../StatsManager';
import {first, isFunction} from '../../utils';

function isDecoratorCall(...args: any[]) {
    return !isFunction(first(args));
}

export default function(f: any, statsManager: StatsManager, ...args: any[]) {
    if (!isDecoratorCall(...args)) {
        const [target, ...otherArgs] = args;
        return f(target, statsManager, ...otherArgs);
    }

    return (...params: any[]) => {
        const descriptors = params[2];
        descriptors.value = f(descriptors.value, statsManager, ...args);
        return descriptors;
    };
}
