const GROUP_REGEXP = /\${(\w*)}/g;

function getClassName(constructor: any) {
    if (typeof constructor.getClassName === 'function') {
        return constructor.getClassName();
    }

    // @khoden: Рефлексия - ЗЛО!
    // FIXME: Переделать на static getClassName
    return constructor.name;
}

function callerParams(obj: any) {
    const params: {[key: string]: any} = {};

    if (obj && obj.constructor) {
        params.type = getClassName(obj.constructor).toLowerCase();
    }

    return params;
}

export default function(name: any, obj: any) {
    if (!GROUP_REGEXP.test(name)) {
        return name;
    }

    const params = callerParams(obj);

    return name.replace(GROUP_REGEXP, (...args: any[]) => params[args[1]]);
}
