import {first} from '../utils';

const markers = new Map();

function _setBefore(name: any, value: any) {
    markers.set(name, value);
}

function _getBefore(name: any) {
    return markers.get(name);
}

let mark = (signal: any) => {
    const now = performance.now();
    _setBefore(signal, now);
};

let measure = (statsManager: any, signal: any) => {
    const now = performance.now();

    const before = _getBefore(signal);
    const value = now - before;

    if (before > 0 && value > 0) {
        statsManager.addSample(`${signal}.time`, Math.floor(value));
    }
};

let measureNative = (statsManager: any, signal: any, from: any, options: {[key: string]: any} = {}) => {
    performance.mark(signal);

    const measureName = `${signal}.measure`;
    performance.measure(measureName, from, signal);
    const measures = performance.getEntriesByName(measureName);

    if (!statsManager.isFirstOnlySupport() || (measures.length > 1 && options.firstOnly)) {
        return;
    }

    const value = Math.abs(first(measures).duration);

    if (value > 0) {
        statsManager.addSample(`${signal}.time`, Math.floor(value));
    }
};

function mock() {
    /* mock */
}

if (!performance || !performance.now) {
    // INFO For monitoring with measure helper use browser with performance.now support
    mark = mock;
    measure = mock;
}

if (!performance || !performance.mark || !performance.measure || !performance.getEntriesByName) {
    // INFO: For monitoring with nativeMeasure helper use browser with performance.measure support
    measureNative = mock;
}

export {mark, measure, measureNative};
