import decorate from './lib/decorate';
import signalName from './lib/signalName';

let promise = (f: any, statsManager: any, name: any) => {
    return function(this: any) {
        const before = performance.now();
        const result = f.apply(this, arguments);

        const signal = signalName(name, this);

        if (!result || !result.then) {
            return result;
        }

        result.then(
            () => {
                const now = performance.now();
                statsManager.addSample(`${signal}.time`, Math.ceil(now - before));
            },
            () => {
                statsManager.incrementCounter(`${signal}.failure.count`, 'mmmm');
            },
        );

        return result;
    };
};

function mock(f: any) {
    return function(this: any) {
        return f.apply(this, arguments);
    };
}

if (!performance || !performance.now) {
    // INFO: For monitoring with promise helper use browser with performance.now support
    promise = mock;
}

export default function(statsManager: any, ...args: any[]) {
    return decorate(promise, statsManager, ...args);
}
