export function first(arr?: any) {
    if (!Array.isArray(arr)) {
        return;
    }

    return arr[0];
}

export function isFunction(f?: any) {
    return typeof f === 'function';
}

export function isEmpty(arr?: any) {
    return !Array.isArray(arr) || arr.length === 0;
}

export function isNumber(value?: any) {
    return typeof value === 'number' && isFinite(value);
}

export function omit(obj: any, ...fields: string[]) {
    const clone = Object.assign({}, obj);
    for (const field of fields) {
        delete clone[field];
    }
    return clone;
}
