import collections


class Args(list):
    pass


def print_config_attribute(attribute, indent=0):
    result = ""
    for key, value in attribute.items():
        if isinstance(value, list) and not isinstance(value, Args):
            values = value
        else:
            values = [value]

        for v in values:
            result += "  " * indent

            if v is None:
                result += "# "

            result += "{}:".format(key)

            if isinstance(v, Args):
                result += " {}\n".format(" ".join(map(str, v)))
            elif isinstance(v, collections.abc.Mapping):
                result += "\n"
                result += "{}\n".format(print_config_attribute(v, indent=indent + 1))
            elif isinstance(v, str):
                result += " \"{}\"\n".format(v)
            elif isinstance(v, bool):
                result += " {}\n".format("yes" if v else "no")
            else:
                result += " {}\n".format(v)

    return result


def iter_attribute(config):
    if config is None:
        return

    if isinstance(config, list):
        for elem in config:
            yield elem
    else:
        yield config


def transform_attribute(config, key, func):
    if config is None or key not in config:
        return

    if isinstance(config, list):
        subconfigs = config[key]
        for idx in range(len(subconfigs)):
            subconfigs[idx] = func(subconfigs[idx])
    else:
        config[key] = func(config[key])


def print_unbound_config(config):
    return print_config_attribute(config)


def get_by_path(d, keys):
    for key in keys[:-1]:
        d = d.get(key)
        if not isinstance(d, dict):
            return None
    return d.get(keys[-1])


def set_by_path(d, keys, value):
    for key in keys[:-1]:
        d = d.setdefault(key, {})
    d[keys[-1]] = value
