#!/bin/sh

if ( which protoc3 >/dev/null ); then
    protoc=$(which protoc3)
else
    protoc=$(which protoc)
fi

PROTOBUF_DIR=src/protobuf
OUTPUT_DIR=src/vmagent_pb
PLUGIN=scripts/protoc-gen-http-rpc.py
HTTP_PLUGIN=scripts/protoc-gen-http-rpc.py

mkdir -p ${OUTPUT_DIR}

# Compile client stub
"${protoc}" \
       -I ${PROTOBUF_DIR} \
       --plugin=protoc-gen-httprpc=${HTTP_PLUGIN} \
       --httprpc_out=${OUTPUT_DIR} \
       --python_out=${OUTPUT_DIR} \
       ${PROTOBUF_DIR}/*.proto

touch ${OUTPUT_DIR}/__init__.py
