#!/usr/bin/python

import os
import socket
import struct


WORKDIR = os.getcwd()
DEFAULT_CONFIG_PATH = os.path.join(WORKDIR, 'vm.config')
MONITOR_PATH = os.path.join(WORKDIR, 'mon.sock')
VMAGENT_PATH = os.environ.get('VMAGENT_PATH', '')

STORAGE_PATH = '/qemu-persistent'
CONFIG_PATH = "/".join([STORAGE_PATH, "current.state"])
DELTA_PATH = "/".join([STORAGE_PATH, "current.qcow2"])
IMAGE_PATH = "/".join([STORAGE_PATH, 'image'])
STATE_PATH = os.path.join(STORAGE_PATH, 'last_status')
IMAGE_FOLDER_PATH = '/'.join([STORAGE_PATH, "image_folder"])

LOG_DIR = os.path.join(STORAGE_PATH, "logs")
SERIAL_PATH = "/".join([LOG_DIR, "serial.log"])
VMAGENT_LOG_PATH = os.path.join(LOG_DIR, 'vmagent.log')

QEMU_LAUNCHER_PATH = os.path.join(VMAGENT_PATH, 'scripts/qemu_launcher.sh')
SKYNET_LAUNCHER_PATH = os.path.join(VMAGENT_PATH, 'scripts/skynet_launcher.sh')
RESCUE_LAUNCHER_PATH = os.path.join(VMAGENT_PATH, 'scripts/rescue_launcher.sh')

WINDOWS_READY = (os.access('/opt/CloudbaseInitSetup_0_9_11_x64.msi', os.F_OK) and
                 os.access('/opt/CloudbaseInitSetup_0_9_11_x86.msi', os.F_OK) and
                 os.access('/opt/cloudbase-init.conf', os.F_OK) and
                 os.access('/opt/cloudbase-init-unattend.conf', os.F_OK))

QEMU_WIN_LAUNCHER_PATH = os.path.join(VMAGENT_PATH, 'scripts/qemu_win_launcher.sh')

HOST = os.environ.get('HOST', "anon_qemuvm")
PORT = os.environ.get('PORT', "7255")

VCPU_NR = os.environ.get('VCPU_NR', "1")
MEM = os.environ.get('MEM', "1G")
DISK_SIZE = os.environ.get('DISK_SIZE', "10485760")

TAP_DEV = os.environ.get('TAP_DEV', "tap7255")
TAP_LL = os.environ.get('TAP_LL', "#ERROR")
VM_IP = os.environ.get('VM_IP', "#ERROR")
VM_AUX_IP = os.environ.get('VM_AUX_IP', '#ERROR')

if VM_IP != '#ERROR':
    buf = list(struct.unpack("BBBBBBBBBBBBBBBB", socket.inet_pton(socket.AF_INET6,  VM_IP)))
    buf = buf[0:13] + [(buf[13] + 1) % 256] + buf[14:16]
    SKYNET_IP = socket.inet_ntop(socket.AF_INET6, struct.pack("BBBBBBBBBBBBBBBB", *buf))
else:
    SKYNET_IP = '#ERROR'

if VM_AUX_IP != '#ERROR':
    buf = list(struct.unpack("BBBBBBBBBBBBBBBB", socket.inet_pton(socket.AF_INET6,  VM_AUX_IP)))
    buf = buf[0:13] + [(buf[13] + 1) % 256] + buf[14:16]
    SKYNET_AUX_IP = socket.inet_ntop(socket.AF_INET6, struct.pack("BBBBBBBBBBBBBBBB", *buf))
else:
    SKYNET_AUX_IP = '#ERROR'


IMG_PATH = IMAGE_PATH
CURRENT_PATH = DELTA_PATH

HOSTNAME = os.environ.get('HOSTNAME', "#ERROR")
INSTANCE_ID = HOSTNAME
HOST_DC = next((tag.split('a_dc_')[1].upper() for tag in os.environ.get('tags', '').split()
                if tag.startswith('a_dc_')), '')
