from __future__ import unicode_literals

import sys
import logging
from logging import handlers

import os

from . import config as server_config
from sepelib.util.log import setup_logging_to_file


LOG_MAX_BYTES = 10 ** 7
LOG_BACKUP_COUNT = 10


def setup_logging():
    # disable requests module logging
    logging.getLogger('requests').setLevel(logging.WARNING)
    logging.getLogger('requests.packages.urllib3.connectionpool').setLevel(logging.ERROR)

    # Common logger
    if not os.path.exists(server_config.LOG_DIR):
        os.mkdir(server_config.LOG_DIR)
    handler = _create_log_handler(server_config.VMAGENT_LOG_PATH)
    logger = setup_logging_to_file(handler,
                                   redirect_stderr=False)

    # Output CRITICAL to stderr
    stderr_handler = logging.StreamHandler(sys.stderr)
    stderr_handler.setLevel(logging.CRITICAL)
    logger.addHandler(stderr_handler)


def _create_log_handler(log_path):
    return handlers.RotatingFileHandler(log_path, maxBytes=LOG_MAX_BYTES, backupCount=LOG_BACKUP_COUNT)
