#!/bin/bash -x

# Id variables:
#
# HOST : instance host
# PORT : instance port
# LOGIN_PASSWORD : default user credentails
# 
# Resource limits:
# 
# VCPU_NR : vcpu numbert
# MEM : vm memory
# DISK_SIZE : disk size
#
# Paths:
#
# IMG_PATH : path to vm disk image resource
# STORAGE_PATH : path to persistent storage
# 
# Net settings:
#
# TAP_DEV : host tap device name
# TAP_LL : host tap device link-local address
# VM_IP : vm ipv6 address

: ${HOST:="anon_win_qemuvm"}
: ${PORT:=7255}
: ${LOGIN_PASSWORD:="P@ssw0rd"}
: ${VCPU_NR:=1}
: ${MEM:="1G"}
: ${DISK_SIZE:="10485760"}
: ${MODE:="gencfg"}

MEM_MB=$(echo $MEM | sed 's:\([0-9]\+\)M:\1:g')
MEM=${MEM_MB}M

# Warn user about inconsistent qcow2 to be created
VIRTUAL_DISK_SIZE=$(qemu-img info $IMG_PATH --output json | python -c "import json; import sys; print json.loads(sys.stdin.read())[\"virtual-size\"]")

if [[ $VIRTUAL_DISK_SIZE -gt $DISK_SIZE ]]; then
    echo "WARNING: REQUESTED VIRTUAL DISK IS SMALLER THAN ITS BASE"
fi

VM_HOSTNAME=$HOST
WORKDIR=$PWD

: ${IMG_PATH:?"No image path supplied"}
: ${IMG_HASH:="NOIMGHASH"}
: ${STORAGE_PATH:?"No storage path supplied"}

: ${INSTANCE_ID=$(jq .configurationId -r ./dump.json)}

: ${CURRENT_PATH:?"No delta path supplied"}

: ${LOG_DIR:=$STORAGE_PATH"/logs"}

mkdir $LOG_DIR || true

#FIXME: Shoud be rotated in chroot
: ${SERIAL_LOG:=$LOG_DIR"/serial.log"}

VMCONF_PATH=$STORAGE_PATH"/vmconf"
VM_MAC="52:54:00:12:34:56"

: ${TAP_LL:?"No link-local address supplied"}
: ${TAP_DEV:?"No tap device name supplied"}
: ${VM_IP:?"No vm ipv6 address supplied"}

MON_PORT=$((PORT+1)) # PORT + 1 - for qemu monitor
SERIAL_PORT=$((PORT+2)) # PORT + 2 - for qemu serial
VNC_PORT=$((PORT+3)) # PORT + 3 - for vnc

if [[ -e $VMCONF_PATH ]]; then
    rm -rv $VMCONF_PATH
fi


# Creating network config
# No fastbone for now

mkdir $VMCONF_PATH

mkdir -p $VMCONF_PATH/openstack_drive/openstack/latest

tee $VMCONF_PATH/openstack_drive/openstack/latest/meta_data.json <<EOF
{"hostname": "$VM_HOSTNAME", "network_config":{"content_path": "network_config"}, "uuid": "$(uuid)" }
EOF

tee $VMCONF_PATH/openstack_drive/openstack/latest/user_data <<EOF
#ps1_sysnative
\$intr = Get-WmiObject win32_networkadapter -Filter "MACAddress = '52:54:00:12:34:56'" | select NetConnectionID, InterfaceIndex
\$index = \$intr.InterfaceIndex
\$name = \$intr.NetConnectionID
netsh interface ipv6 add address interface=\$index address=$VM_IP/128 store=persistent
netsh interface ipv6 add route interface=\$index prefix=::/0 nexthop=$TAP_LL metric=1
netsh interface ipv6 add dnsservers name=\$index address=2a02:6b8:0:3400::1 validate=no
netsh interface ipv6 add dnsservers name=\$index address=2a02:6b8::1:1 validate=no
netsh interface set interface name=\$name admin=disabled
netsh interface set interface name=\$name admin=enabled
EOF

mkdir -p $VMCONF_PATH/openstack_drive/openstack/content

tee $VMCONF_PATH/openstack_drive/openstack/content/network_config <<EOF
iface eth0 inet static
hwaddress ether 52:54:00:12:34:56
address 192.168.1.2
netmask 255.255.255.0
EOF

if [[ "$MODE" == "yp" ]]; then
tee -a $VMCONF_PATH/openstack_drive/openstack/content/network_config <<EOF
gateway 192.168.1.1
EOF
fi

tee -a $VMCONF_PATH/openstack_drive/openstack/content/network_config <<EOF
post-up ip -6 addr add fe80::5054:00ff:fe12:3456/64 dev eth0

EOF

NET="-netdev tap,id=qemu_net,ifname=$TAP_DEV,script=no -device virtio-net-pci,netdev=qemu_net,mac=$VM_MAC"

if [ -r "/dev/kvm" ] && [ -w "/dev/kvm" ]; then
    KVM_FLAG="--enable-kvm -cpu SandyBridge,+vmx"
else
    KVM_FLAG=""
fi

CHARDEV+="-chardev socket,id=monsk,path=./mon.sock,server,nowait -mon monsk -monitor none "
CHARDEV+="-chardev file,id=serial_log,path=$SERIAL_LOG -serial chardev:serial_log"

DISPLAY+="-usbdevice tablet -vnc unix:./vnc.sock,password -device VGA,id=video0,vgamem_mb=64,bus=pci.0,addr=0x2 "
RTC="-rtc base=utc,driftfix=slew -global kvm-pit.lost_tick_policy=discard -no-hpet "


DRIVE_PATH=""
if [[ $IMAGE_TYPE == "RAW" ]]; then
    DRIVE_PATH=$IMG_PATH
    qemu-img resize $IMG_PATH $SIZE_FOR_RAW
else
    DRIVE_PATH=$CURRENT_PATH
    if [[ ! -e $CURRENT_PATH ]]; then
        rm $CURRENT_PATH
        qemu-img create -f qcow2 -b $IMG_PATH $CURRENT_PATH $DISK_SIZE
    fi
fi

# Redirect tcp connections to unix sockets
socat TCP6-LISTEN:$VNC_PORT,reuseaddr,fork UNIX-CONNECT:./vnc.sock &
socat UDP6-LISTEN:$VNC_PORT,reuseaddr,fork UNIX-CONNECT:./vnc.sock &

cp /opt/CloudbaseInitSetup_0_9_11_x64.msi $VMCONF_PATH/openstack_drive/
cp /opt/CloudbaseInitSetup_0_9_11_x86.msi $VMCONF_PATH/openstack_drive/
cp /opt/cloudbase-init.conf $VMCONF_PATH/openstack_drive/
cp /opt/cloudbase-init-unattend.conf $VMCONF_PATH/openstack_drive/

/usr/local/bin/qemu-system-x86_64 \
$KVM_FLAG \
-m "$MEM" -smp "$VCPU_NR,sockets=1,cores=$VCPU_NR,threads=1" \
-nographic \
-nodefaults \
-machine pc \
-drive file="$DRIVE_PATH",if=virtio,cache=none,id=root_disk,if=none \
-device virtio-blk-pci,scsi=off,bus=pci.0,addr=0x4,drive=root_disk,id=root_disk,bootindex=1 \
-drive file=fat:"$VMCONF_PATH/openstack_drive",if=virtio,file.label=config-2,readonly=on,cache=none \
$CHARDEV \
$DISPLAY \
$RTC \
$NET

RET=$?

pkill -9 -P $$

exit $RET
