#!/bin/bash -x

# Id variables:
#
# PORT : instance port
# 
# Resource limits:
# 
# DISK_SIZE : disk size
#
# Paths:
#
# IMG_PATH : path to vm disk image resource
# CURRENT_PATH : path to delta disk
# STORAGE_PATH : path to persistent storage


: ${PORT:=7255}
: ${VCPU_NR:=1}
: ${MEM:="1G"}

: ${IMG_PATH:?"No image path supplied"}
: ${STORAGE_PATH:?"No storage path supplied"}
: ${CURRENT_PATH:?"No delta path supplied"}

: ${LOG_DIR:=$STORAGE_PATH"/logs"}

mkdir $LOG_DIR || true

#FIXME: Shoud be rotated in chroot
: ${SERIAL_LOG:=$LOG_DIR"/serial.log"}

MON_PORT=$((PORT+1)) # PORT + 1 - for qemu monitor
VNC_PORT=$((PORT+3)) # PORT + 3 - for vnc

if [ -r "/dev/kvm" ] && [ -w "/dev/kvm" ]; then
    KVM_FLAG="--enable-kvm -cpu host"
else
    KVM_FLAG=""
fi

CHARDEV+="-chardev socket,id=monsk,path=./mon.sock,server,nowait -mon monsk -monitor none "
CHARDEV+="-chardev file,id=serial_log,path=$SERIAL_LOG -serial chardev:serial_log"
DISPLAY+="-usbdevice tablet -vnc unix:./vnc.sock,password -vga std "

DRIVE_PATH=""
if [[ $IMAGE_TYPE == "RAW" ]]; then
    DRIVE_PATH=$IMG_PATH
else
    DRIVE_PATH=$CURRENT_PATH
    if [[ ! -e $CURRENT_PATH ]]; then
        qemu-img create -f qcow2 -b $IMG_PATH $CURRENT_PATH $DISK_SIZE
    fi
fi

# Redirect tcp connections to unix sockets
socat TCP6-LISTEN:$VNC_PORT,reuseaddr,fork UNIX-CONNECT:./vnc.sock &
socat UDP6-LISTEN:$VNC_PORT,reuseaddr,fork UNIX-CONNECT:./vnc.sock &

RESCUE="-kernel /boot/vmlinuz -initrd /boot/initrd"

/usr/local/bin/qemu-system-x86_64 \
$KVM_FLAG \
-m "$MEM" -smp "$VCPU_NR" \
-nographic \
-nodefaults \
-drive file="$DRIVE_PATH",if=virtio,cache=none \
$CHARDEV \
$DISPLAY \
$RESCUE \
-append 'root=/dev/ram0 rdinit=/bin/sh init=/bin/sh ro console=tty1 loglevel=7'

RET=$?

pkill -9 -P $$

exit $RET
