import collections

from tabulate import tabulate

from infra.vmagent.src.vmagent_pb import vmset_pb2
from infra.vmagent.src.vmctl import api
from infra.vmagent.src.vmctl.actions.list_helpers import ListField


def proto_date_to_str(value):
    return value.ToDatetime()


def get_enum_name(obj):
    return vmset_pb2.BackupStatus.State.Name(obj.status.state)


AVAILABLE_FIELDS = collections.OrderedDict([
    ('id', ListField('Id', attr='meta.id')),
    ('task_id', ListField('Task id', attr='spec.sandbox_task_id')),
    ('date', ListField('Date', attr='meta.creation_time',
                       formatter=proto_date_to_str)),
    ('status', ListField('Status', value_getter=get_enum_name)),
    ('url', ListField('Url', attr='status.url')),
])


def fetch_vm_backups(args):
    api_client = api.VMAgentClient(
        token=args.token,
        proxyhost=args.proxyhost,
        ssl_none=args.ssl_none
    )
    backups = api_client.list_backups(cluster=args.yp_cluster, pod_id=args.pod_id)
    fields = AVAILABLE_FIELDS.values()
    count = 0
    rows = []
    for backup in backups:
        count += 1
        row = [count]
        for field in fields:
            row.append(field(backup))
        rows.append(row)
    return rows, ['Index'] + [f.field_name for f in fields]


def run(args):
    rows, headers = fetch_vm_backups(args)

    print(tabulate(rows, headers=headers, tablefmt='fancy_grid'))
