import operator


class ListField(object):
    def __init__(self, field_name, attr=None, value_getter=None, formatter=None):
        """
        :type field_name: str
        :type attr: str
        :type value_getter: callable
        :type formatter: callable
        """
        self.field_name = field_name
        self.attr = attr
        self.value_getter = value_getter or self.default_getter
        self.formatter = formatter or str

    def default_getter(self, obj, **kwargs):
        """
        :type obj: object
        """
        return operator.attrgetter(self.attr)(obj)

    def __call__(self, obj, **kwargs):
        """
        :type obj: object
        """
        value = self.value_getter(obj, **kwargs)
        return self.formatter(value)


def int_to_str_gigabytes(value):
    """
    :type value: int
    """
    return '{}G'.format(value / 1024 ** 3)
