// Package kexec_helper provide kexec-tools integration with wall-e.agent and ya-salt.
package main

import (
	"a.yandex-team.ru/infra/wall-e/agent/kexec_helper/lib"
	"errors"
	"fmt"
	"os"
	"os/exec"
	"os/user"
	"strings"
)

//Basic execution errors handler
func errHandler(e error) {
	fmt.Println(e)
	os.Exit(1)
}

//Root/sudo privileges checking function
func checkSudo() error {
	usr, err := user.Current()
	if err != nil {
		return err
	}
	if usr.Uid != "0" {
		err := errors.New("you should run with root privileges or with sudo")
		return err
	}
	return nil
}

//Shell execution wrapper
func shellExec(cmd string, arguments string, dry bool) string {
	if dry {
		fmt.Printf("DRY RUN: %s %s\n", cmd, arguments)
		return ""
	} else {
		args := strings.Fields(arguments)
		cmdExec := exec.Command(cmd, args...)
		stdout, err := cmdExec.Output()
		if err != nil {
			errHandler(err)
		}
		return string(stdout)
	}
}

func main() {
	err := checkSudo()
	if err != nil {
		errHandler(err)
	}
	fl, err := kexeclib.GetFlags()
	if err != nil {
		errHandler(err)
	}
	yasalt := shellExec("ya-salt", "status -o json", false)
	kern, err := kexeclib.GetKernelVersion(yasalt)
	if err != nil {
		errHandler(err)
	}
	kargs := kexeclib.KexecCmdline(kern)
	if kexeclib.IsNeedKernReboot(kern, fl) {
		shellExec("kexec", kargs, fl.Dry)
		shellExec("shutdown", "-r +1", fl.Dry)

	}

}
