# -*- coding: utf-8 -*-
from __future__ import absolute_import

from juggler.bundles import cli, Manifest
from . import (walle_disk, walle_memory, walle_link, walle_reboots, walle_tainted_kernel,
               walle_cpu, walle_cpu_caches, walle_cpu_capping,
               walle_fs_check, walle_meta, walle_bmc,
               walle_clocksource, walle_gpu, walle_fstab, walle_infiniband, common)


def create_manifest():
    manifest = Manifest(name="wall-e-checks-bundle", build_number=common.get_bundle_version())

    manifest.register(walle_disk.juggler_check)
    manifest.register(walle_memory.juggler_check)
    manifest.register(walle_cpu.juggler_check)
    manifest.register(walle_cpu_caches.juggler_check)
    manifest.register(walle_cpu_capping.juggler_check)
    manifest.register(walle_link.juggler_check)
    manifest.register(walle_gpu.juggler_check)
    manifest.register(walle_bmc.juggler_check)
    manifest.register(walle_reboots.juggler_check)
    manifest.register(walle_tainted_kernel.juggler_check)
    manifest.register(walle_fs_check.juggler_check)
    manifest.register(walle_meta.juggler_check)
    manifest.register(walle_clocksource.juggler_check)
    manifest.register(walle_fstab.juggler_check)
    manifest.register(walle_infiniband.juggler_check)

    return manifest


def main():
    cli(obj=create_manifest())
