#!/usr/bin/env python

# Provides: walle_clocksource

from __future__ import unicode_literals, absolute_import

import json

from juggler.bundles import as_check, Status, Event
from .common import get_hw_watcher_status, oldstyle_main, timestamp

CHECK_NAME = "walle_clocksource"


def run_check():
    result = get_hw_watcher_status("clock")
    return juggler_status(result["status"]), metadata(result)


def juggler_status(hw_watcher_status):
    return {
        "OK": Status.OK,
        "FAILED": Status.CRIT,
    }.get(hw_watcher_status, Status.WARN)


def metadata(hw_watcher_result):
    return {
        "reason": hw_watcher_result["reason"][0],
        "timestamp": hw_watcher_result["timestamp"],
        "status": hw_watcher_result["status"]
    }


def make_event(status, metadata):
    return Event(status, json.dumps(metadata))


@as_check(name=CHECK_NAME)
def juggler_check():
    try:

        return make_event(*run_check())
    except Exception as e:
        return make_event(Status.WARN, {
            "reason": "Can't get status from hw-watcher: {}".format(e),
            "timestamp": timestamp(),
        })


if __name__ == "__main__":
    oldstyle_main(CHECK_NAME, juggler_check())
