#!/usr/bin/env python

# Provides: walle_cpu_caches

from __future__ import unicode_literals, absolute_import

import json

from juggler.bundles import as_check, Status, Event
from .common import get_hw_watcher_status, oldstyle_main, make_warning_event

CHECK_NAME = "walle_cpu_caches"


def run_check():
    result = get_hw_watcher_status("cpu")
    return juggler_status(result["status"]), {"result": result}


def juggler_status(hw_watcher_status):
    return {
        "OK": Status.OK,
        "FAILED": Status.CRIT,
    }.get(hw_watcher_status, Status.WARN)


def make_event(status, metadata):
    return Event(status, json.dumps(metadata))


@as_check(name=CHECK_NAME)
def juggler_check():
    try:
        return make_event(*run_check())
    except Exception as e:
        return make_warning_event(e)


if __name__ == "__main__":
    oldstyle_main(CHECK_NAME, juggler_check())
