#!/usr/bin/env python

# Provides: walle_disk
from __future__ import absolute_import

import copy
import json

from juggler.bundles import as_check, Status, Event
from .common import get_hw_watcher_status, oldstyle_main, make_warning_event

CHECK_NAME = "walle_disk"


def run_check():
    result = get_hw_watcher_status("disk")
    status = get_check_status(result["status"])
    return status, {"result": result}


def get_check_status(hw_watcher_status):
    return {
        "OK": Status.OK,
        "RECOVERY": Status.OK,
        "WARNING": Status.OK,
        "FAILED": Status.CRIT,
        "UNKNOWN": Status.CRIT
    }.get(hw_watcher_status, Status.WARN)


def shrink_description(metadata):
    # Juggler limits description length to 1000 bytes, so try to save space here by dropping non-sensitive data

    metadata = copy.deepcopy(metadata)

    while True:
        description = json.dumps(metadata)
        if len(description) <= 1000:
            return description

        try:
            result = metadata["result"]

            if result.pop("failed_disks", None) is not None:
                continue

            reason = result["disk2replace"]["reason"]
            if len(reason) > 1:
                reason.pop(0)
                continue

            reason = result.get("reason", [])
            if len(reason) > 1:
                reason.pop(0)
                continue
        except Exception:
            pass

        return description


def make_event(status, metadata):
    description = shrink_description(metadata)
    return Event(status, description)


@as_check(name=CHECK_NAME)
def juggler_check():
    try:
        return make_event(*run_check())
    except Exception as e:
        return make_warning_event(e)


if __name__ == "__main__":
    oldstyle_main(CHECK_NAME, juggler_check())
