#!/usr/bin/env python
# -*- coding: utf-8 -*-
# Provides: walle_gpu

from .common import oldstyle_main, get_hw_watcher_status, make_event, make_warning_event
from juggler.bundles import as_check, Status

CHECK_NAME = "walle_gpu"


def get_gpu_status():
    result = get_hw_watcher_status("gpu")
    hww_status = result["status"]
    if hww_status in {"OK", "WARNING"}:
        status = Status.OK
    elif hww_status == "FAILED":
        reasons = result["reason"]
        # list of supported prefixes here:
        # https://wiki.yandex-team.ru/haas/services/hw-watcher/gpu/
        # ecc, memory and driver are currently not actionable
        if all(r.startswith("driver") for r in reasons):
            status = Status.OK
        else:
            status = Status.CRIT
    else:
        status = Status.WARN

    return status, {"result": result}


@as_check(name=CHECK_NAME)
def juggler_check():
    try:
        return make_event(*get_gpu_status())
    except Exception as e:
        return make_warning_event(e)


if __name__ == '__main__':
    oldstyle_main(CHECK_NAME, juggler_check())
