#!/usr/bin/env python
# -*- coding: utf-8 -*-
# Provides: "walle_infiniband"

from .common import oldstyle_main, get_hw_watcher_status, make_event, make_warning_event
from juggler.bundles import as_check, Status

CHECK_NAME = "walle_infiniband"


def get_gpu_status():
    result = get_hw_watcher_status("infiniband")
    hww_status = result["status"]
    if hww_status in {"OK", "WARNING"}:
        status = Status.OK
    elif hww_status == "FAILED":
        status = Status.CRIT
    else:
        status = Status.WARN
    return status, {"result": result}


@as_check(name=CHECK_NAME)
def juggler_check():
    try:
        return make_event(*get_gpu_status())
    except Exception as e:
        return make_warning_event(e)


if __name__ == '__main__':
    oldstyle_main(CHECK_NAME, juggler_check())
