#!/usr/bin/env python

# Provides: walle_meta

from __future__ import absolute_import

from os.path import exists as path_exists

from .common import get_command_output, oldstyle_main, HW_WATCHER_PATH, get_bundle_version, timestamp, make_event
from juggler.bundles import as_check, Status

CHECK_NAME = "walle_meta"


def get_hw_watcher_version():
    if not path_exists(HW_WATCHER_PATH):
        return Status.WARN, 'File "{}" does not exist'.format(HW_WATCHER_PATH)

    try:
        out = get_command_output([HW_WATCHER_PATH, '--version'])
        version = out.strip().split(' ')[1]
        return Status.OK, version
    except Exception as e:
        # we are going to redeploy this host to fix that
        return Status.CRIT, str(e)


def run_check():
    bundle_version = get_bundle_version()
    status, hw_watcher_version = get_hw_watcher_version()
    description = {
        'bundle': bundle_version,
        'timestamp': timestamp(),
        'hw_watcher': hw_watcher_version
    }
    return status, description


@as_check(name=CHECK_NAME)
def juggler_check():
    try:
        return make_event(*run_check())
    except Exception as e:
        return make_event(Status.WARN, "Failed to get data for {} check: {}".format(CHECK_NAME, e))


if __name__ == '__main__':
    oldstyle_main(CHECK_NAME, juggler_check())
