#!/usr/bin/env python

# Provides: walle_tainted_kernel

import json

from juggler.bundles import as_check, Status, Event
from .common import oldstyle_main, get_command_output

CHECK_NAME = "walle_tainted_kernel"

err_map = {
    0b1: 'P',
    0b10: 'F',
    0b100: 'S',
    0b1000: 'R',
    0b10000: 'M',
    0b100000: 'B',
    0b1000000: 'U',
    0b10000000: 'D',
    0b100000000: 'A',
    0b1000000000: 'W',
    0b10000000000: 'C',
    0b100000000000: 'I',
    0b1000000000000: 'O',
    0b10000000000000: 'E',
    0b100000000000000: 'L'
}

crit_errors = ['F', 'S', 'M', 'B', 'D']


def make_event(status, msg):
    return Event(status, json.dumps({"result": {"reason": [msg]}}))


def run_check():
    tainted = int(get_command_output("sysctl -n kernel.tainted".split()))
    msg = ""
    for key in sorted(err_map.keys()):  # sort keys for tests
        if tainted & key:
            msg += err_map.get(key)

    if msg != "":
        status = Status.OK
        for c in crit_errors:
            if c in msg:
                status = Status.CRIT
        msg = "kernel.tainted have statuses " + msg
        msg += "; see https://nda.ya.ru/t/TG8imMBE4JPHAv for check errors"
        return status, msg
    else:
        return Status.OK, "Ok"


@as_check(name=CHECK_NAME)
def juggler_check():
    try:
        return make_event(*run_check())
    except Exception as e:
        return make_event(Status.WARN, "Failed to get data for the check: {}".format(e))


if __name__ == '__main__':
    oldstyle_main(CHECK_NAME, juggler_check())
