"""DC shortnames management"""

from walle_cli.common import register_subparsers, register_parser


def init(subparsers):
    subparsers = register_subparsers(subparsers, "dc-shortnames", "DC shortnames management")

    register_parser(subparsers, "list", _get_shortnames, "List all names and paths")

    parser = register_parser(subparsers, "get", _get_one_shortname, "Return shortname by path")
    parser.add_argument("path", help="Path to get name")

    parser = register_parser(subparsers, "add", _add_shortname, "Add")
    parser.add_argument("path", help="Path to add")
    parser.add_argument("name", help="Name to add")

    parser = register_parser(subparsers, "delete", _delete_shortname, "Delete")
    parser.add_argument("path", help="Path to delete")


def _get_shortnames(client, args):
    dumped_map = client.get_shortnames()["result"]
    for element in dumped_map:
        print("path: ", element["path"], " name: ", element["name"], "\n")


def _get_one_shortname(client, args):
    print(client.get_one_shortname(args.path))


def _add_shortname(client, args):
    print(client.add_shortname(args.path, args.name))


def _delete_shortname(client, args):
    print(client.delete_shortname(args.path))
