"""Deploy config management."""

from walle_cli.common import register_subparsers, register_parser, render_result


def init(subparsers):
    subparsers = register_subparsers(subparsers, "deploy-configs", "Deploy configs management", short="c")
    parser = register_parser(subparsers, "list", _on_list, "List all available configs")
    parser.add_argument("-p", "--provisioner", help="filter by provisioner")


@render_result
def _on_list(client, args):
    configs = client.get_deploy_configs(provisioner=args.provisioner)
    return {"configs": configs}
