import signal
import sys
import collections
import yaml

# Add representer for OrderedDict to have an ability to preserve the dict order on dump
yaml.add_representer(collections.OrderedDict, yaml.representer.SafeRepresenter.represent_dict)


def terminate(*args, **kwargs):
    sys.exit("Got a termination UNIX signal. Exiting...")


signal.signal(signal.SIGINT, terminate)
signal.signal(signal.SIGTERM, terminate)
signal.signal(signal.SIGQUIT, terminate)

# Suppress Broken pipe IOError for print function
signal.signal(signal.SIGPIPE, signal.SIG_DFL)
