![M-O robot](_assets/M-O.png)

У Wall-E есть свой агент, установку которого настоятельно рекомендуется включать во все наливки, используемые в вашем проекте.

## Установка

Пакет находится в репозитории `common`:
`deb http://common.dist.yandex.ru/common stable/all/`

и ставится командой `apt-get install yandex-wall-e-agent`.


## Зачем нужен Wall-E.Agent {#agent-installation-reasons}

Wall-E очень важно иметь следующую информацию о каждом хосте, находящимся под его контролем:
* Свитч/порт в который воткнута машина, чтобы:
  * Знать, на каком порту надо щелкать VLAN'ами.
  * Определять IPv6-префикс, в котором необходимо аллоцировать EUI-64 IPv6-адреса.
* Активный MAC-адрес:
  * Необходим для генерации EUI-64 IPv6-адреса, когда Wall-E прописывает машину в DNS.
  * Если инженеры ДЦ переткнут порт сетевой карты, то машина получит другой IPv6-адрес, и ее DNS-записи станут невалидными. Wall-E.Agent позволяет вовремя заметить смену активного MAC-адреса и автоматически поменять DNS-записи так, чтобы они указывали на актуальные IP-адреса.
  * Если в качестве наливайки используется [LUI](https://setup.yandex-team.ru/), то ей необходимо указывать активный MAC-адрес, с которого будет грузиться машина. Wall-E умеет перебирать все MAC-адреса машины при наливке через LUI, но если активный MAC-адрес известен, это сильно ускоряет процесс наливки.

Информацию о свитч/порте и активном MAC-адресе можно также взять из [Eine](https://eine.yandex-team.ru/) или [выгрузок RackTables](https://racktables.yandex.net/export/netmap/), но:
* Информация в Eine обновляется только во время преднастройки машины и очень полезна в случае замены тушки, но в последствии может быстро устареть, если машину перекоммутируют в другой свитч, забыв провести через преднастройку, либо просто переткнут кабель в другой порт сетевой карты.
* Информация в RackTables обновляется раз в 3-4 часа, имеет погрешность в один час и может быть недостоверной: если хост делит сетевые MAC-адреса с IPMI, то они также будут светиться как активные, а в случае сложных сетевых конфигураций или заворачивания трафика, выгрузки и вовсе могут выдавать неверный свитч/порт.

Поэтому информации из Eine и RackTables оказывается недостаточно, и нужен еще один источник - внутренний, который будет предоставлять максимально актуальные данные с самих машин, а RackTables и Eine будут использоваться в крайних случаях, когда на машине нет ОС или она не может загрузиться, и единственный способ получить информацию о свитч/порт/MAC - это воспользоваться внешними источниками.

## Принцип работы

Wall-E.Agent - это минимальный Python'овский скрипт, который зависит только от стандартной библиотеки Python, чтобы не тянуть лишние зависимости на машины.

`yandex-wall-e-agent` устанавливает данный скрипт, а также прописывает его в cron так, чтобы каждые 10-20 минут он репортил всю необходимую информацию о хосте в Wall-E.

Пакет зависит от [lldpd](https://vincentbernat.github.io/lldpd/), который необходим Wall-E для определения свитч/порта, в который воткнута машина. В Поиске по просьбе NOC lldpd установлен на каждой машине, то же самое справедливо и для многих других проектов, поэтому эта зависимость не должна вас пугать.

**Единственное, о чем имеет смысл упомянуть отдельно - это то, что Wall-E.Agent перезапускает lldpd, если тот не отвечает. lldpd имеет ряд родовых травм, благодаря которым в определенных случаях сервис может зависнуть/перестать запускаться, поэтому Wall-E.Agent работает в роли watchdog'а для lldpd.**

Сам Wall-E.Agent не выполняет никакой работы - только репортит информацию о машине в Wall-E. Wall-E проверяет полученные данные и, если это необходимо и разрешено в настройках хоста/проекта, [правит DNS-записи](automation/dns.md) данного хоста.
