
# Алгоритм автоматического лечения машин

В Wall-E используется относительно простой набор правил, который говорит примерно следующее:
* ## {#automatic-memory-changing}
  Если сработала проверка `walle_memory`, то в зависимости от проблемы:
    * создаётся заявка на замену сбойной планки памяти
    * создаётся заявка на некорректный доступный объём памяти
    * несбалансированное распределение памяти между NUMA-нодами
    * низкую частоту работы памяти
если заявка не устранила срабатывание проверки, Wall-E отправит хост в преднастройку, а если преднастройка не устранит срабатывание проверки, то Wall-E отправит хост [в статус `dead`](#dead-host) на ручной разбор.
* ## {#automatic-bmc-repairing}
  Если сработала проверка `walle_bmc` зависание, dns, батарейка, остальное ...  , то в зависимости от проблемы:
   * если обнаружено зависание BMC, wall-e запустит задачу, которая сделает bmc reset. Если это не поможет, Wall-E создаст заявку на недоступный IPMI. Если и это не поможет, Wall-E отправит хост в преднастройку, а после – создаст [заявку типа `2nd_time_node`](#2nd-time-node).
   * если IPMI интерфейс пропал из DNS, Wall-E создаст заявку на недоступность IPMI интерфейса (IPMI Host Missing). Если это не поможет, Wall-E отправит хост [в статус `dead`](#dead-host) на ручной разбор.
   * если обнаружено, что села батарейка, то Wall-E создаст заявку на замену батарейки. Если это не поможет, Wall-E отправит хост [в статус `dead`](#dead-host) на ручной разбор.
   * если обнаружена другая проблема BMC, то Wall-E отправит хост в преднастройку. Если преднастройка не помогает, то Wall-E отправит хост [в статус `dead`](#dead-host) на ручной разбор.
* ## {#automatic-disk-changing}
  Если сработала проверка `walle_disk`,  кабель, битые сектора, производительность, остальное ... то в зависимости от типа проблемы:
  * если обнаружена потенциальная проблема с кабелем, Wall-E создаст заявку на замену кабеля. Если это не поможет, Wall-E отправит хост [в статус `dead`](#dead-host) на ручной разбор.
  * если обнаружены битые сектора (bad blocks, a.k.a. `ATA_IO_ERROR`), то Wall-E отправит хост в переналивку, это такое поведение не отключено для схемы автоматики. Если переналивка не помогает, то Wall-E создаст заявку на замену диска. Если это не поможет, Wall-E отправит хост [в статус `dead`](#dead-host) на ручной разбор.
  * если обнаружено падение производительности диска, Wall-E попробует ребутнуть хост. Если ребут не поможет, то Wall-E создаст заявку на замену диска. Если это не поможет, Wall-E отправит хост [в статус `dead`](#dead-host) на ручной разбор.
  * при других проблемах с дисками Wall-E создаст заявку на замену диска. Если диск входит в raid, то после замены диска hw-watcher пересоберёт raid. Если диск не входит в raid, то Wall-E перенальёт хост после замены диска. Если замена диска не поможет, Wall-E отправит хост [в статус `dead`](#dead-host) на ручной разбор.
  * если hw-watcher не смог определить проблемный диск, то Wall-E отправит хост в преднастройку. Если преднастройка не поможет, Wall-E отправит хост [в статус `dead`](#dead-host) на ручной разбор.
* ## {#automatic-link-repairing}
  Если сработала проверка `walle_link`, Wall-E создаст заявку в BOT на проверку сетевого интерфейса. Если это не поможет, Wall-E отправит хост [в статус `dead`](#dead-host) на ручной разбор.
* ## {#automatic-cpu-repairing}
  Если сработала проверка cpu_caches с проблемой CPU, Wall-E создаст заявку на замену CPU. При этом CPU могут не заменить, а поменять местами, чтобы определить неисправности сокета. Если замена CPU не помогла, Wall-E отправит хост в преднастройку. Если это не помогает, Wall-E создаст [заявку типа `2nd_time_node`](#2nd-time-node).
* ## {#automatic-overheat-repairing}
  Если сработала проверка `walle_cpu_caches` с перегревом, то необходимо создать формализованную заявку на устранение перегрева. При этом, если перегрето большинство хостов в стойке, Wall-E создаст заявку на перегрев стойки. Если после закрытия заявки проверка продолжает срабатывать, хосты отправятся [в статус `dead`](#dead-host) на ручной разбор.
* Если сработала проверка `walle_cpu` (система не видит некоторые ядра) - Wall-E отправит хост в преднастройку ([eaas](../guide/hosts.md#host-profiling)). Если это не поможет, Wall-E отправит хост [в статус `dead`](#dead-host) на ручной разбор.
* ## {#automatic-capping-repairing}
  Если сработала проверка `walle_cpu_capping`, Wall-E попробует ребутнуть хост. Если это не поможет, Wall-E создаст заявку на устранение проблемы с каппингом CPU. Если это не поможет, Wall-E отправит хост [в статус `dead`](#dead-host) на ручной разбор.
* ## {#automatic-gpu-repairing}
  Если сработала проверка `walle_gpu`, то Wall-E создаст заявку на починку GPU с указанием типа проблемы: GPU отвалилась, переключилась на низкую скорость или перегрелась. Если это не поможет, Wall-E создаст тикет на владельцев хоста [для ручного разбора](#check-report).
* ## {#automatic-kernel-tainted-repairing}
  Если сработала проверка `walle_tainted_kernel` - Wall-E перезагрузит хост. Если это не поможет, Wall-E отправит хост в преднастройку. Если преднастройка не поможет, Wall-E отправит хост [в статус `dead`](#dead-host) на ручной разбор.
* ## {#automatic-reboots-repairing}
  Если сработала проверка `walle_reboots` (хост зависает или ребутается самостоятельно) - Wall-E отправит хост в преднастройку ([eaas](../guide/hosts.md#host-profiling)) с нагрузочным тестом и последующей переналивкой. Если это не поможет, Wall-E создаст [заявку типа `2nd_time_node`](#2nd-time-node).
* ## {#automatic-fsck-repairing}
  Если сработала проверка `walle_fs_check` - Wall-E перезагрузит хост, если перезагрузка не помогает или ошибки возвращаются – Wall-E отправит хост в преднастройку с write-тестами дисков и переналивкой. Если это не поможет, Wall-E отправит хост [в статус `dead`](#dead-host) на ручной разбор.
* ## {#automatic-rack-repairing}
  Если все хосты в стойке недоступны, или недоступны по сети все хосты из нижней или верхней части стойки, Wall-E создаст заявку на ремонт стойки. Эта заявка будет иметь высокий приоритет. Если заявка не поможет, все хосты будут отправлены [в статус `dead`](#dead-host) на ручной разбор.
* ## {#automatic-unreachable-repairing}
  Если сработали проверки `UNREACHABLE` или `ssh` (или обе). Wall-E перезагрузит хост и проверит настройку VLAN-ов (если в проекте настроена VLAN-схема). Если перезагрузка не помогает, Wall-E отправит хост в преднастройку. Если не помогает и преднастройка, то Wall-E перенальёт хост. Если переналивка не помогла, то Wall-E отправит хост в преднастройку с тегом extra-load, если же и она не помогла - создаст [заявку типа `2nd_time_node`](#2nd-time-node).
  В этом правиле починки Wall-E учитывает сетевую топологию, а также физическое расположение машин: при поломке большого количества машин за одним свитчом/в одной стойке проблемным считается свитч/стойка, а не машина, и никаких автоматических действий при этом не производится. У этого правила есть ограничения по времени, зависимость от состояния проверок `walle_rack` и `netmon` и проверка на HBF-учения.
* ## {#automatic-hw-checks-missing-repairing}
  Если проверки, получаемые от hw-watcher-а, перестали приходить, но проверка `walle_meta` работает, то Wall-E перезагрузит хост, если перезагрузка не помогает или ошибки возвращаются – Wall-E перенальёт хост. Если это не поможет, хост будет отправлен [[в статус `dead`](#dead-host)](#dead-host) на ручной разбор. В аудитном логе хоста появится запись вида "All hw-watcher checks are missing" или "Most of hardware checks are invalid".
* ## {#automatic-all-passive-checks-missing-repairing}
  Если все пассивные проверки c хоста отсутствуют уже сутки, но хост доступен по сети, это означает, что juggler-агент на хосте сломался (например, забился раздел /home или случилось что угодно ещё). В такой ситуации Wall-E сначала перезагрузит хост, если это не поможет -- Wall-E отправит хост в преднастройку и перенальёт. В аудитном логе хоста появится запись вида "All passive checks are missing". Процесс починки хоста выглядит точно так же, как если бы он был недоступен, но в конце Wall-E отправит хост [в статус `dead`](#dead-host) на ручной разбор.

Для "собственных проверок проекта" правила ещё проще. При добавлении проверки в схему, администратор указывает, какие действия могут быть выполнены для исправления проблемы. Сейчас вариантов два: ребут и переналивка, можно выбрать оба, должно быть включено хотя бы одно действие.
* Если разрешён ребут хоста – wall-e отправит хост в ребут
* Если ребут не разрешён – wall-e оправит хост в переналивку
* Если ребут был выполнен, но не помог, и если переналивка разрешена, то wall-e оправит хост в переналивку
* Если ребут и переналивка не помогли, то wall-e [создаст тикет в стартреке](#check-report), согласно настройкам [отчётов о сломанных хостах](../guide/reports.md). При этом если в настройках отчёты отключены, wall-e все равно создаст тикет: эта настройка отключает ежедневные отчёты-подборки, а не тикеты на починку.

Проверки выполняются в том порядке, в котором они отсортированы в схеме проверок. Прежде чем начать чинить проблему по загоревшейся проверке, Wall-E дождётся актуального обновления статуса для предыдущей проверки – это позволяет задавать взаимную зависимость между проверками.

В будущем данные правила будут меняться и расширяться, но мы постараемся сделать так, чтобы они всегда были максимально простыми, чтобы действия Wall-E были максимально предсказуемы для администраторов, а сами правила можно было полностью покрыть unit-тестами.

Для диагностики действий Wall-E по конкретному хосту можно смотреть историю событий о нем в Juggler: https://juggler.yandex-team.ru/raw_events/?query=host=<$HOST>, например [https://juggler.yandex-team.ru/raw_events/?query=host=sas1-1200.search.yandex.net](https://juggler.yandex-team.ru/raw_events/?query=host=sas1-1200.search.yandex.net).

### {#dead-host}
Wall-E отправляет хост в статус `dead` для того, чтобы сигнализировать владельцам хостов о проблеме, с которой не справилась автоматика. Такие хосты попадают в [ежедневные отчёты](../guide/reports.md).
### {#2nd-time-node}
Wall-E отправляет хосты на "углубленную диагностику" в ITDC, где инженеры ищут причины нетипичных проблем. По результатам разбора таких хостов мы либо улучшаем автоматику, либо добавляем новые способы починки. В основном в эти заявки попадают хосты, с которыми имеющаяся автоматика не справилась.
### {#check-report}
Wall-E создаёт индивидуальные тикеты для сломанных хостов, по тому же алгоритму, что и [ежедневные отчёты](../guide/reports.md). Индивидуальные тикеты делаются для одного хоста, а не для всех вместе, и не ротируются каждый день. При этом если в настройках проекта отчёты отключены, wall-e все равно создаст тикет: настройка отключает ежедневные отчёты-подборки, а не тикеты на починку.
