
# Проверки

## Juggler {#juggler-base}
В данный момент Wall-E использует информацию по следующим Juggler-проверкам для всех проектов:

* `UNREACHABLE`: "активная" проверка, выполняемая самим Juggler-ом, ICMP ping.
* `ssh`: "активная" проверка, выполняемая самим Juggler-ом, ssh handshake.
* `META`: информационная проверка, не обрабатывается самостоятельно, но участвует в принятии решений при обработки общего состояния всех проверок.

Для корректной работы этих проверок требуется проколоть дырки от серверов Juggler-а до серверов проекта. Подробнее про активные проверки и доступы можно узнать [в документации juggler-а](https://docs.yandex-team.ru/juggler/aggregates/actives).

Для активных проверок Wall-E настраивает в Juggler-е "флаподав". Когда флаподав срабатывает, Wall-E переводит проверку в статус "suspected". Если проверка проходит через флаподав в критическом состоянии, то Wall-E переводит проверку в статус failed и приступает к починке сервера. При этом учитываются данные, полученные из netmon-а и проверка стойки, которую Wall-E делает сам, поэтому починка сервера может быть отложена до получения актуальных данных по этим проверкам.

## HW-проверки {#juggler-hw-checks}
В данный момент Wall-E позволяет включить использование следующих Juggler-проверок для проектов, которые готовы использовать эти проверки для починки хостов (см. [настройки автоматики](general.md#automation-config) ):

* `walle_memory`: Транслирует в Juggler результаты проверок hw_watcher по памяти.
* `walle_disk`: Транслирует в Juggler результаты проверок hw_watcher по дискам, добавляя немного своей логики, которая затем используется в Wall-E.
* `walle_link`: Транслирует в Juggler результаты проверок hw_watcher по скорости сетевого интерфейса.
* `walle_gpu`: Транслирует в Juggler состояние проверок GPU от hw-watcher.
* `walle_bmc`: Транслирует в Juggler результаты проверок hw_watcher по различным параметрам из bmc, например, уровень заряда батарейки
* `walle_reboots`: Транслирует в Juggler результаты проверок по количеству перезагрузок на сервере (сервер может перезагружаться не только через wall-e, он может перезагружаться, например, сам).
* `walle_tainted_kernel`: Транслирует в Juggler результаты проверок ядра Linux (если ядро в [tainted-режиме](https://www.kernel.org/doc/html/v5.4/admin-guide/tainted-kernels.html), сервер требуется перезагрузить).
* `walle_cpu`: Транслирует в Juggler результаты различных проверок CPU.
* `walle_cpu_capping`: Транслирует в Juggler наличие ограничения мощности на CPU из-за проблем с питанием.
* `walle_fs_check`: Транслирует в Juggler количество ошибок файловой системы.
* `walle_meta`: Отображает работоспособность проверок из бандла, а так же транслирует версию бандла и версию hw-watcher-а.

Для корректной работы этих проверок требуется установить на сервера проекта [hw-watcher](https://wiki.yandex-team.ru/haas/services/hw-watcher/) и [juggler-client](https://docs.yandex-team.ru/juggler/client/basics), установить на сервер требуемые проверки (для этого достаточно прописать бандл `wall-e-checks-bundle` в конфигурационный файл juggler-client-а) и проколоть дырки от серверов проекта до серверов juggler-а.

{% info warning %}

**При этом необходимо**, чтобы hw-watcher был сконфигурирован для работы с Wall-E - в противном случае может получиться так, что Wall-E и hw-watcher будут вдвоем лечить одни и те же диски / память. Процедура настройки hw-watcher для работы с Wall-E предельно проста и описана [здесь](https://wiki.yandex-team.ru/haas/services/hw-watcher/walle/).

{% endinfo %}

У проекта должны быть заданы профиль и тэги преднастройки по умолчанию. Это необходимо, т. к. часть проблем с памятью и дисками решается только через преднастройку.

У проекта должна быть задана VLAN-схема. Это нужно для того, чтобы Wall-E мог выполнять автоматическую преднастройку машин: после преднастройки ему необходимо переключить сервер в правильные VLAN'ы.

Эти проверки включаются при использовании любой схемы проверок в проекте. У бандла имеется отдельная [страничка с документацией](../checks_bundle.md), на которую можно давать ссылку.

## Netmon {#netmon}
Кроме Juggler-а, есть и другие системы, которые предоставляют необходимую для починки серверов информацию, в частности, [netmon](https://wiki.yandex-team.ru/netmon/) предоставляет данные о связности сегментов сетей с детализацией до уровня отдельных свичей. Wall-E использует эту информацию, чтобы не пытаться доломать сервера, которые недоступны из-за проблем в сети. Информация, полученная из netmon-а, записывается в wall-e на хост в виде проверки, которая в дальнейшем обрабатывается примерно так же (теми же правилами), что и остальные проверки.

Для корректной работы этой системы требуется [установить netmon-агент](https://wiki.yandex-team.ru/netmon/#install) на сервера проекта. netmon-агент устанавливается из sky-core, то есть для работы придётся "заехать в skynet".

## Собственные (синтетические) проверки Wall-E {#wall-e-checks}
Wall-E выполняет и собственные проверки, которые отображают знание самого Wall-E о проблемах с хостами. Прямо сейчас такая проверка всего одна: агрегированная проверка состояния стойки. Если в одной стойке недоступно большое количество хостов, то Wall-E считает такую стойку сломанной и не пытается чинить сами хосты. Вместо этого, нужно чинить саму стойку. Информация записывается в wall-e на хост в виде проверки, которая в дальнейшем обрабатывается примерно так же (теми же правилами), что и остальные проверки.

## Проверки из схемы проверок {#automation-plot-checks}
Схемы проверок позволяют выбрать, какие проверки будут использоваться Wall-E для починки хостов. Если в проекте не указана никакая схема проверок, то Wall-E использует только самую базовую информацию для починки сервера: [проверки UNREACHABLE и ssh](#juggler-base).

Если в проекте указана схема автоматики, то Wall-E будет использовать [hw-проверки](#juggler-hw-checks) и собственные проверки проекта, перечисленные в схеме автоматики.

В Wall-E существует "общая" схема автоматики, в которой нет и не будет "собственных проверок": "Wall-E hw-checks" (`wall-e-hw-checks`). Включение этой схемы автоматики для проекта включит [hw-проверки](#juggler-hw-checks).

Создание схемы проверок описано в разделе про [настройки автоматики](general.md#automation-config).

Названием проверки, добавленной в схему автоматики, должно быть то же самое название, которое используется в Juggler-е. Wall-E на самом деле пойдёт в Juggler и заведёт проверку с таким названием, изменения по этой проверке будут отправляться в Wall-E. Разработку этой проверки ведёт команда проекта – разработчики Wall-E не могут сами покрыть всего разнообразия инфраструктуры в Яндексе.

Статусы Juggler-проверок должны отражать действие, которое требуется выполнить по результатам этой проверки:
1. `OK` – действий не требуется. Wall-E присвоит проверке статус `passed`.
2. `WARN` - требуется вручную проверить результат проверки. Например, если проверка не смогла получить необходимые данные или не смогла загрузить необходимые модули. Wall-E присвоит проверке статус `suspected`.
3. `INFO` – с точки зрения Wall-E – то же самое, что `WARN`. Если у этой проверки есть другие пользователи, кроме Wall-E, эти статусы могут иметь разную семантику. На практике `INFO` никто не использует.
4. `CRIT` - требуется выполнить действие, настроенное для проверки в схеме автоматики. Wall-E присвоит проверке статус `failed`.

Если timestamp, указанный в `description` проверки (см. ниже), отстаёт от текущего времени, то Wall-E дождётся обновления по проверке, прежде, чем выносить решение. На это время проверке будет присвоен статус `missing`.

Чтобы Wall-E мог использовать проверку, она должна возвращать результат в определённом формате – этот результат попадает в поле description. Wall-E ожидает, что description будет содержать json такого вида:

```json
{"timestamp": 1527604958.816106, "reason": "message that explains check status"}
```

За консультацией по поводу разработки своих проверок смело обращайтесь в нашу очередь [WALLESUPPORT](https://st.yandex-team.ru/WALLESUPPORT), мы поможем и концептуально, и примерами кода.

## Дополнительные проверки из бандла Wall-E проверок {#bundled-extra-checks}
В бандл проверок, описанный выше, входит проверка `walle_clocksource`, которую можно включить в схему проверок, если проблема актуальна для проекта. Эта проверка использует hw-watcher для определения текущего источника времени в системе. Если используется медленный источник `hpet`, то проверка переходит в статус CRIT. В схеме проверок можно настроить реакцию, например, перезагрузку сервера – в результате перезагрузки система должна включить быстрый источник времени `tsc`. Если перезагрузка не помогает, Wall-E создаст тикет в очереди, на которую настроены [отчёты о сломанных хостах](../guide/reports.md).

## Отключение проверок {#checks-disabling}
В Wall-E есть возможность отключить автопочинку для проверок на уровне проекта. Для этого надо перейти на экран управления проектом и найти там секцию `Disabled checks`. После отключения проверки, Wall-E не будет пытаться чинить хост при её поломке.
