# DNS

Wall-E может автоматически аллоцировать имена для хостов, предугадывать IPv6-адреса и прописывать их в DNS. Этот функционал используется в [первичной настройке хостов](../guide/hosts.md#host-preparing) и при починке DNS-записей (без аллокации новых имён, конечно).

Генерация имен, определение VLAN, которые должны быть назначены на хост, и выделение сетей в данный момент в Яндексе имеет слишком много специфики в каждом проекте, поэтому было принято решение принять наиболее распространённые практики за "стандарт", и обобщать их на всю компанию. По вопросам поддержки конфигурации DNS для вашего проекта  можно обращаться в поддержку Wall-E [через тикет в соответствующей очереди Трекера](https://st.yandex-team.ru/createTicket?queue=WALLESUPPORT)

{% note warning %}

Пререквизитом для автоматической починки DNS является установленный на все хосты проекта [Wall-E.Agent](../agent.md). Почему - см. [Зачем нужен Wall-E.Agent](../agent.md#agent-installation-reasons).

{% endnote %}

{% note tip %}

Важно, чтобы ip-адреса, которые конфигурируются на сервере, совпадали с теми, которые выбирает Wall-E. Про алгоритм выбора ip-адреса в Wall-E написано ниже. Настройка сервера, как правило, сводится к использованию [yandex-netconfig](https://wiki.yandex-team.ru/runtime-cloud/yandex-netconfig/).

{% endnote %}

## Когда и что делает DNS-автоматика {#dns-constr}
Wall-E изменяет имя хоста только в следующих ситуациях:
1. Новый хост [вводится в эксплуатацию](../guide/hosts.md#host-preparing): будет выбрано [новое имя](#dns-algorithm-names), это имя будет прописано в DNS. Это действие нельзя отключить. Wall-E может сохранить существующее имя хоста, если оно подходит под шаблон и было свободно в течение некоторого времени.
2. Хост выводится из эксплуатации ([переводится в другой проект](../guide/hosts.md#project-switching) с опцией `--release`): хост получит несуществующее имя в несуществующей зоне wall-e.yandex.net, старое имя хоста будет удалено из DNS. Это действие нельзя отключить. Если вам надо просто перевести хост из одного своего проекта в другой свой проект, без переналивки и очистки дисков, то возможно вам не нужен `--release`.

Wall-E изменяет DNS-записи только в следующих ситуациях:
1. В Wall-E [добавляется](../guide/hosts.md) работающий хост: существующее имя хоста будет прописано в DNS, если требуется. Действие опциональное, включается флагом `--dns` при добавлении хоста.
2. Новый хост [вводится в эксплуатацию](../guide/hosts.md#host-preparing): будет выбрано [новое имя](#dns-algorithm-names), это имя будет прописано в DNS. Это действие нельзя отключить. Wall-E может сохранить существующее имя хоста, если оно подходит под шаблон и было свободно в течение некоторого времени.
3. Хост выводится из эксплуатации ([переводится в другой проект](../guide/hosts.md#project-switching) с опцией `--release`): хост получит несуществующее имя в несуществующей зоне wall-e.yandex.net, старое имя хоста будет удалено из DNS. Это действие нельзя отключить. Если вам надо просто перевести хост из одного своего проекта в другой свой проект, без переналивки и очистки дисков, то возможно вам не нужен `--release`.
4. Пользователь запустил задачу `check-dns` для хоста: записи для существующего имени будут добавлены и/или исправлены при необходимости. Это ручная операция.
5. [Автоматика Wall-E (dns-fixer)](#dns-fixing) обнаружила отсутствие записей в DNS/некорректные записи в DNS: записи для существующего имени будут добавлены и/или исправлены. Поведение включается/отключается на уровне проекта: сначала dns-fixer разрешается для проекта в глобальных настройках wall-e, после чего владелец проекта может включить или выключить dns-автоматику в настройках проекта.

Работа с DNS осуществляется через [DNS API](https://wiki.yandex-team.ru/dynamic-dns/dns-api-v2).

## Автоматическая починка DNS-записей хостов {#dns-fixing}
{% note warning %}

Пререквизитом для автоматической починки DNS является установленный на все хосты проекта [Wall-E.Agent](../agent.md). Почему - см. [Зачем нужен Wall-E.Agent](../agent.md#agent-installation-reasons).

{% endnote %}

{% note tip %}

Убедитесь, что ip-адреса, которые конфигурируются на сервере, совпадают с теми, которые выбирает Wall-E. Настройка сервера, как правило, сводится к использованию [yandex-netconfig](https://wiki.yandex-team.ru/runtime-cloud/yandex-netconfig/).

{% endnote %}

DNS-записи нужно постоянно держать в актуальном состоянии и желательно делать это автоматически, т. к. за всем не уследишь:
* инженер ДЦ может перекоммутировать машину в другой свитч или просто переткнуть кабель в другой порт на сетевой карте - и у машины поменяется IPv6-адрес;
* админ может сам прописать машину в DNS, но рано или поздно забудет почистить или добавить PTR-записи;
* кто-нибудь когда-нибудь обязательно случайно удалит не ту запись из DNS.

Wall-E старается иметь в своей базе максимально актуальную информацию по сетевой конфигурации каждой машины (свитч, активный MAC-адрес) и при изменении одного из параметров автоматически вносить необходимые изменения в DNS. При этом важно, чтобы IP-адреса, которые настраиваются на сервере совпадали с теми, которые выбирает Wall-E. Алгоритм выбора IP-адреса описан ниже, настройка сервера в основном сводится к использованию [yandex-netconfig](https://wiki.yandex-team.ru/runtime-cloud/yandex-netconfig/).

На данный момент автоматическая починка DNS-записей включается для проектов администраторами Wall-E, т. к. для ее работы требуется наличие соответствующих прав в [DNS API](https://wiki.yandex-team.ru/dynamic-dns/dns-api-v2). После этого владельцы проекта могут самостоятельно отключать этот вид автоматики на время технических проблем, дополнительно можно отключить для каждого хоста в отдельности с помощью [механизма ограничений](../guide/restrictions.md).

Вы можете выдать wall-e либо полные права на доменную зону, тогда wall-e сможет добавлять и удалять любые записи, либо "работные права", которые позволят wall-e редактировать и удалять только те записи, которые он создал сам. Права нужно выдавать пользователю robot-walle.

Защита от уничтожения DNS-записей всего проекта автоматикой в случае внутренних ошибок, как и для всей остальной автоматики, реализуется через [установку лимитов](limits.md).

### {#manual-check-dns}
Запустить задачу починки dns-записей для хоста можно вручную командой
`wall-e hosts check-dns $host -m "DNS records were broken by someone"`

## Алгоритм проверки и настройки DNS-записей {#dns-algorithm}
Wall-E использует информацию об активном MAC-адресе, полученную от wall-e агента (или другой системы, об этом в [следующем разделе](#mac-sources)), для того, чтобы определить, какой именно IP-адрес нужно прописать в DNS. Wall-E не прописывает в DNS любой IP-адрес, присутствующий на сервере, потому что это приведёт к коллизиям. Wall-E – это одна из систем, участвующих в настройке кластера, и предполагается, что алгоритмы, используемые этими системами, синхронизированы между собой. Это значит, что система, которая выбирает IP-адрес для сервера, использует тот же самый алгоритм, который использует Wall-E. Именно поэтому поддержка DNS не включается для всех проектов по умолчанию.

Текущий алгоритм имеет два режима: для хостов имеющих IPv4 адрес, и для IPv6-only хостов. VLAN-схема проекта тоже влияет на работу алгоритма: для схемы `search` дополнительно настраиваются записи для fastbone-интерфейса, которого нет в схеме `static`. Поддержка hbf/mtn (a.k.a "/64 на хост") тоже имеется: для этого надо задать в настройках проекта параметр `hbf-project-id`.

### Источники активных MAC адресов {#mac-sources}
* [Walle агент (там же и про eine, и про racktables есть немного)](https://docs.yandex-team.ru/wall-e/agent) присылает mac раз в 10-20 минут. Наилучший вариант.
* Eine - обновляет у себя MAC только во время преднастройки. Walle синкает его себе если MAC по дате свежее того, что есть в базе, и не старее 12 часов
* Racktables - MAC от racktables пессимизируется на 1 час и, соответственно, имеет возможность синкнуться в базу walle только если актуальных маков от других источников нет

### Алгоритм починки DNS-записей для IPv6-only серверов.
1. Wall-E ищет IPv6-сеть на основании даных о физическом и сетевом расположении сервера: используется информация о cвиче, к которому подключен сервер и проектном VLAN-е:
   * Для mtn и l3-сегмента используется выгрузка [l3-tors.txt](https://racktables.yandex.net/export/l3-tors.txt). switch + VLAN однозначно идентифицируют `/64` сеть. Для mtn в сеть встраивается hbf-project-id.
   * Для l2-сегмента используется выгрузка [net-layout.xml](https://racktables.yandex.net/export/net-layout.xml). Сеть привязывается к датацентру, поэтому к паре VLAN<->датацентр может быть привязано несколько сетей, в т.ч. более широкие сети (`/56`, например). Это особый случай, в светлом прекрасном будущем на выходе из этого пункта у Wall-E всегда будет одна сеть. Сейчас Wall-E запоминает и корректно обрабатывает связь со всеми /64 сетями, игнорируя остальные.
2. Wall-E использует информацию об активном MAC-адресе сервера, полученную от wall-e.agent, чтобы вычислить IPv6-адрес в найденной сети. Здесь опять возможны варианты: если в проекте задан `hbf-project-id`, то он используется для вычисления IPv6-адреса, если нет, то IPv6-адрес вычисляется на сновании EUI-64 схемы. В l2-сегменте Wall-E вычисляет список из нескольких IPv6-адресов, для каждой доступной сети.
   * ## {#eui-64}
     Пример использования EUI-64: MAC-адрес сервера `78:e3:b5:08:93:98` записывается в виде `78e3:b508:9398`, в середину вставляется отметка `ff:fe`, предпоследний бит в первом октете инвертируется (вот такой алгоритм) и полученное значение подставляется в найденную маску сети `2a02:6b8:0:160b::/64`, получается `2a02:6b8::a19:7ae3:b5ff:fe08:9398`. Этот же адрес прилетает на хост по RA, то есть, после наливки хост получает точно такой же адрес.
   * ## {#mtn}
     Пример использования [mtn/hbf-схемы](https://jing.yandex-team.ru/files/n-malakhov/Screen%20Shot%202016-09-21%20at%2016.46.58-1.png): MAC-адрес сервера `78:e3:b5:08:93:98` записывается в виде `b508:9398` (приходится обрезать старшие октеты), hbf-project-id `1478` записывается в виде `0:1478` (другой пример: `12e5` используется в виде `0:12e5`). Эти числа подставляются в маску сети `2a02:6b8:0:160b::/64`, получается IPv6-адрес `2a02:6b8:0:160b:0:1407:b508:9398`. Этот адрес прописывается на хост init-скриптами, которые используют ту же самую логику, что и Wall-E (например, в случае с yandex-netconfig, нужно дописать в /etc/network/interfaces `ya-netconfig-project-id-host-method mac`, см. [документацию](https://wiki.yandex-team.ru/runtime-cloud/yandex-netconfig/)).
3. Если проект использует поисковую схему, то аналогичные вычисления производятся для fastbone-интерфейса. Для статической схемы используется только основной VLAN проекта, для поисковой – только основной и fastbone VLAN-ы.
4. Wall-E проверяет наличие прямых записей в DNS для найденных IP-адресов:
   * Если есть запись, связывающая имя сервера с вычисленным IP-адресом (в l2-сегменте – с любым из вычисленных адресов), то Wall-E считает эту запись корректной.
   * Если есть запись, которая указывает на другой IP-адрес, Wall-E её удалит.
   * Если есть запись, связывающая другое имя с вычисленным IP-адресом, Wall-E её удалит.
   * Если корректной записи не нашлось, то Wall-E пропишет в DNS найденный IPv6-адрес (в l2-сегменте – первый из найденных).
5. Wall-E проверяет наличие обратных записей в DNS для найденных IP-адресов:
   * Если есть запись, связывающая вычисленный IP-адрес с именем сервера (в l2-сегменте – любой из вычисленных адресов), то Wall-E считает эту запись корректной.
   * Если есть запись для другого IP-адреса, Wall-E её удалит.
   * Если есть запись, связывающая вычисленный IP-адрес с другим именем, Wall-E её удалит.
   * Если корректной записи не нашлось, то Wall-E пропишет в DNS обратную запись для вычисленного адреса (в l2-сегменте – для первого из найденных).

### Алгоритм починки DNS-записей для серверов, имеющих IPv4 адреса.
1. Наличие IPv4 адреса определяется по наличию соответствующей записи в DNS, грубо говоря, если команда `host $servername` выдаёт IPv4-адрес, то это наш случай. В этом месте возникает проблема курицы и яйца, если удалить все записи из DNS, то хост превратится в IPv6-only. Запись в DNS будет обновлена, если потребуется.
2. По IPv4 адресу, локации и проектному VLAN-у определяется IPv6 сеть для backbone на основе информации, прописанной в [ya.subr](https://a.yandex-team.ru/arc/trunk/arcadia/yweb/webscripts/admscripts/scripts/startup/ya.subr#L92).
3. Wall-E вычисляет IPv6-адрес сервера по схеме IPv6-net ^ IPv4-address. Пример: IPv4-адрес `178.154.132.91` приводится к формату `b29a:845b`, это значение подставляется в маску IPv6 сети `2a02:6b8:0:160b::/64`, полученную из ya.subr, получается IPv6-адрес `2a02:6b8:0:160b::b29a:845b`.
4. На этом отличия от IPv6-only заканчиваются, далее Wall-E работает точно так же, как описано выше: для поисковой VLAN-схемы вычисляются IP-адреса для fastbone-интерфейса на основе mtn/hbf-схемы или EUI-64, потом происходит проверка, создание и удаление DNS-записей.

### CNAME {#cname}
Wall-E не умеет создавать и редактировать CNAME записи и по факту даже не видит их во всех своих алгоритмах. Есть некоторые особенности работы DNS-API, которые не позволяют "превратить" CNAME-запись в AAAA-запись, поэтому Wall-E не сможет создать или отредактировать запись для хоста, если такая запись уже существует с типом CNAME. Поэтому убедитесь, пожалуйста, что в вашем проекте не используются CNAME-записи, а если используются, то они не интерферируют с записями AAAA (например, имеют другой шаблон или находятся в другом домене). Вам также придётся редактировать CNAME-записи вручную, если вы переименуете хост (например, через БОТ). Если CNAME-запись будет мешать создавать AAAA запись, то удалять её придётся вручную.

## Схема выбора имени для сервера {#dns-algorithm-names}
Есть операции, которые требуют выбора нового имени для серверов: это [ввод нового сервера в эксплуатацию](../guide/hosts.md#host-preparing) и [перевод сервера в другой проект](../guide/hosts.md#project-switching). Переезд между проектами приводит к переименованию, только если хост переводится с опцией `--release`. Записи вносятся в DNS по тому же алгоритму, по которому чинятся записи для хостов, уже имеющих имя. Разница в том, что в данном случае Wall-E сначала сам ищет свободное имя для серевера.

Шаблон имени сервера по умолчанию выглядит так: `{location}{bucket}-{index:04}.project.domain.name`. `{location}` – это трёхбуквенное обозначение датацентра, в котором расположен сервер на момент выбора имени, `{bucket}-{index:04}` – это счётчик, используемый для уникальности fqdn, `project.domain.name` задаётся в настройках проекта администратором Wall-E (не владельцем проекта).

Владельцы проектов могут задать собственный шаблон для короткого имени сервера. Короткое имя – это первый сегмент FQDN, то есть, часть до первой точки. После первой точки идёт dns-domain, указанный в настройках проекта.

Поддерживаемые подставновки в шаблоне: `{index}`, `{bucket}` и `{location}`. Обязательная подстановка в шаблоне – `{index}`. Для неё можно добавить фиксированную ширину с паддингом нулями: `{index:03}`. Если все имена с зафиксированной шириной окажутся занятыми, Wall-E начнёт выдавать ошибку. `{bucket}` это просто способ перенести один разряд из номера в другую часть имени, опционально. Если вы указали `{bucket}`, то надо обязательно фиксировать ширину для `{index:0N}`.

```
$ wall-e projects host-shortname-template set <PROJECT_ID> 'custom-{location}-{index}' -m 'Set custom host short name template'
```

Wall-E гарантирует глобальную уникальность fqdn сервера. Дополнительно, Wall-E гарантирует глобальную уникальность короткого имени на момент переименования сервера: Wall-E не создаст имена `locX-YYYY.project-1.domain.name` и `locX-YYYY.project-2.domain.name` (одинаковые shortname), даже в разных проектах. Если кто-то другой позднее переименует свой хост, без участия Wall-E, и создаст дублирующееся короткое имя, то Wall-E *не будет* переименовывать ваши сервера из-за итого.

## Защита {#dns-protection}
Для того, чтобы оценить риски включения dns-автоматики в вашем проекте, будет полезно ознакомиться с возможными сценариями, в которых что-то может пойти не так.

Как было описано выше, Wall-E работает с индивидуальными записями, а не редактирует весь список записей в зоне. Это значит, что если Wall-E ошибётся, это будет ошибка в записях затронутого сервера, а не уничтожение всей зоны. Примеры таких ошибок: при некорректно настроенной VLAN-схеме Wall-E может удалить fastbone-записи для серверов в проекте или выбрать неправильную сеть для определения IP-адреса и испортить все AAAA и PTR записи для серверов в проекте. Другие dns-записи в той же зоне не будут затронуты. В этом смысле иметь общие dns-зоны на несколько проектов не опасно.

Как было описано выше, Wall-E использует данные из racktables и от Wall-E-агента для определения IP-адресов для хостов. Если эти источники начнут предоставлять ложную информацию, то Wall-E захочет массово редактировать DNS-записи для всех серверов, для которых будет получена недостоверная информация. В случае с racktables проблема будет массовой, и затрагивать все хосты в стойке или даже в очереди. В случае с Wall-E-агентом проблема может быть как глобальной, если в сам Wall-E агент закрадётся ошибка, которая выкатится на все хосты кластера, так и локальной, если на конкретном сервере возникнут проблемы с определением активного mac-адреса.

Для того, чтобы избежать массовых проблем в описанных сценариях у нас есть два уровня защиты:
1. Для защиты от некорректных входных данных у нас есть количественные ограничения: если Wall-E начнёт массово менять DNS-записи, то автоматика отключится. Автоматика может отключиться в одном проекте, если проблема локальная, или глобально, если проблема глобальная.
2. Если в проекте есть хосты, для которых ошибка в dns-записях особенно критична, то для них можно установить ограничение на редактирование dns-записей. Если установить такое ограничение, то починить dns-записи для такого хоста можно будет только ручным запуском задачи check-dns либо вручную, например, через dns-monkey.

## Доступы на редактирование записей в зонах {#dns-zone-permissions}
Вы можете выдать wall-e либо полные права на доменную зону, что позволит wall-e добавлять и удалять любые записи, либо "работные права", которые позволят wall-e редактировать и удалять только те записи, которые он создал сам. Права нужно выдавать пользователю [robot-walle@](https://staff.yandex-team.ru/robot-walle).

Выбор между тем, какие права давать Wall-E зависит от нескольких обстоятельств.

Если в проекте есть хосты, записи для которых управляются какой-то внешней системой, особенно если эта внешняя система периодически генерирует весь файл зоны целиком, то лучше выделить для хостов, заехавших в Wall-E, отдельную зону. Какие права будут у Wall-E на эту зону, пользовательские или роботные – будет неважно, у Wall-E всё равно будут права на все записи, потому что все записи созданы им самим.

Если в проекте нет хостов, записи для которых создаются сторонней системой или если конфликты между системами исключены, то можно просто выдать Wall-E права на основную зону проекта. Если все хосты при заезде в Wall-E будут переименованы, то можно выдать ему роботные права на зону, если же хосты будут заезжать с существующими именами, то лучше выдать пользовательские права, чтобы Wall-E имел возможность чинить записи, когда они сломаются.
