# Автоматика
Мониторинг состояния серверов осуществляется силами [Juggler](https://docs.yandex-team.ru/juggler/). С некоторой периодичностью Wall-E конфигурирует в Juggler-е проверки, которые нужны для его работы. Juggler отправляет в Wall-E результаты проверок, эти результаты используются для принятия решений о необходимости починки серверов.

При выполнении команд на prepare/profile/reboot/redeploy операция считается выполненной только в том случае, если все проверки переходят в нормальное состояние (`passed`). В противном случае машина переводится в статус `dead`, и операция считается завершившейся с ошибкой. Это поведение можно изменить, отдавая команду на reboot/redeploy с опцией `--no-check` - в этом случае команда будет выполнена без последующей проверки состояния хоста, и хост будет переведен в состояние ready (это не отменяет последующие проверки его состояния и автоматическое лечение - см. ниже).

Если хост получил статус `dead` в результате действий пользователя, то даже если впоследствии проверки перейдут в нормальное состояние, он не получит статус `ready` автоматически, и для него не будет срабатывать какая-либо автоматика по устранению неполадок, пока администратор вручную не [переведет его в статус ready](../guide/hosts.md#host-force-status). Если хост получил статус `dead` в результате действий автоматики, то хост может быть переведён снова в статус `ready`, если все его проверки перейдут в состояние "OK" и все правила обработки проверок будут считать, что хост здоров. Это может привести к циклам, когда хост переходит в dead каждые несколько дней, такие хосты попадают в [отчёты](../guide/reports.md), которые Wall-E создаёт для всех проектов.

Статус `dead` является стадией, требующей внимания человека. Предполагается, что администратор на регулярной основе будет просматривать список хостов, находящихся в статусе `dead`, оценивать причину, по которой автоматика не справилась с данной проблемой, устранять эту проблему и [переводить хост в статус ready](../guide/hosts.md#host-force-status), чтобы Wall-E снова начал мониторить его состояние и производить автоматическое лечение.

При выявлении ошибок, которые случаются довольно часто, но с которыми автоматика не может справиться в данный момент, смело сообщайтесь к разработчикам Wall-E: наша задача как раз состоит в том, чтобы покрыть автоматикой максимальное количество проблем и, насколько это возможно, минимизировать ручную работу администраторов.


## Настройки автоматики {#automation-config}
Для каждого проекта отдельно автоматика настраивается с помощью схемы проверок (automation-plot). Схема проверок описывает, какие проверки, специфичные для данного проекта, должны использоваться Wall-E для починки хостов. Одна схема проверок может использоваться в разных проектах, предположительно, это будут проекты одного и того же сервиса, но не обязательно. Мы ожидаем, что в списке собственных проверок проекта будут в основном проверки сервисов, являющихся инфраструктурными сервисами для проекта. Например, для RTC такими проверками могут быть проверки работоспособности porto, iss-агента или skynet-а.

Список собственных проверок проекта может быть пустым, однако создавать самостоятельно такую схему автоматики не требуется: в Wall-E есть "общая" схема автоматики под названием "Wall-E hw-checks" (wall-e-hw-checks). Её можно использовать в любых проектах для того, чтобы включить [hw-проверки](checks.md#juggler-hw-checks).

Чтобы включить схему автоматики для проекта, можно пойти в настройки проекта и выбрать ей в списке под заголовком "Схема проверок". Включить схему проверок можно и через консольный клиент wall-e:
`$ wall-e projects automation-plot set <project-id> wall-e-hw-checks -m 'enable hw-checks for my project'`. Выключить схему автоматики можно командой `wall-e projects automation-plot unset <project-id>`.

После включения схемы автоматики в течение пары минут в UI появятся "квадратики" для добавившихся проверок. Скорее всего, поначалу они будут серыми (информация о проверке отсутствует): новые данные о состоянии проверок появятся в течение нескольких минут (ориентировочно, минут 15-20).

В настоящий момент создать схему автоматики можно только через [UI](https://wall-e.yandex-team.ru/automation-plots) или через наше REST-API, консольный клиент Wall-E не предоставляет такой возможности. Каждая схема автоматики должна иметь уникальный идентификатор и уникальное имя. Не забудьте добавить свой ABC-сервис в список владельцев схемы автоматики.

Добавить проверки в схему автоматики можно на странице редактирования (например, проверки [RTC](https://wall-e.yandex-team.ru/automation-plots/rtc)). Проверки выполняются в том порядке, в котором они расположены в схеме, поэтому на форме можно поменять их порядок. Для каждой проверки требуется указать как минимум одно действие, которое выполнит Wall-E, когда проверка перейдёт в статус CRIT: либо перезагрузка сервера, либо переналивка. Можно указать оба действия, wall-e будет выполнять их по очереди, пока одно из них не исправит проблему. Если ни одно действие не помогло, Wall-E создаст тикет в стартреке. Подробнее см. [алгоритм автоматики](algorithm.md).

Названием проверки, добавленной в схему автоматики, должно быть то же самое название, которое используется в Juggler-е.

## Отключение автоматики {#automation-settings}

Автоматику можно отключить как для отдельного проекта:
`$ wall-e projects automation {enable,disable} $project [all|healing|dns] -m "disable"`

так и для всего Wall-E (требует наличия [админских прав](../guide/authorization.md)):
`$ wall-e settings {disable|enable}_automation -m "disable|enable"`
`$ wall-e settings set [--disable-healing|--enable-healing] [--disable-dns-automation|--enable-dns-automation] -m "disable|enable"`

После отключения автоматической починки серверов Wall-E не будет предпринимать какие-либо действия сам и будет выполнять только те действия, которые были инициированы пользователем. Починка DNS продолжится, если она не отключена тоже.

Если в проекте используется схема автоматики, то можно отключить отдельно сломанную проверку. Это затронет все проекты, которые используют схему автоматики. Отключить можно через UI, со страницы редактирования схема автоматики, либо через консольный Wall-E клиент:
`$ wall-e automation-plots disable-check <check-name> -m "disable broke <check-name> check"`

**Тут важно отметить одну деталь:** если вы отключите автоматику в момент, когда в системе присутствуют задачи, инициированные автоматикой Wall-E (к примеру, лечение хоста через reboot), то эти задачи повиснут до тех пор, пока не выполнится одно из следующих условий:
* Хост вылечится - в этом случае Wall-E мометит его как `ready`.
* Кто-нибудь отменит данную задачу через `wall-e hosts cancel-task $host {ready|dead}`.
* Автоматика будет включена обратно.

Это связано с тем, что в случае неудачного лечения машинки Wall-E будет вынужден предпринять очередное автоматическое действие (переналить, посчитать машинку мертвой), но не сможет этого сделать ввиду отключенной автоматики. Wall-E сам отменит задачу, если ещё не начал её обрабатывать.
