# Защита от уничтожения кластера

## Лимиты на автоматику {#automation-limits}

В Wall-E в данный момент есть два вида автоматики: автоматическая починка серверов (healing) и автоматическая починка DNS (dns fixer). Это два разных типа задач, которые управляются отдельно. Система защиты сознательно организована настолько просто, насколько это возможно. У Wall-E есть встроенные внутренние ограничители на количество автоматических действий. Принцип действия этих ограничений примерно такой же, как у электрических автоматов, какие можно найти в щитке на лестнице ("пробки"): если происходит слишком много автоматических действий, то автомат срабатывает ("вышибает пробки") и Wall-E перестаёт предпринимать какие-либо автоматические действия. После этого должен прийти живой человек, который выяснит, почему так много автоматических действий было предпринято и снова включит автомат.

Лимиты задаются как на уровне проекта, так и на уровне Wall-E (глобальные лимиты). Отдельные выключатели для починки серверов и для DNS позволяют продолжить ремонтировать сервера, когда сработало ограничение на починку DNS и наоборот.

Каждый лимит задаёт ограничение на срабатывание определённой проверки, например "максимальное количество срабатываний проверки UNREACHABLE", "максимальное количество срабатываний проверки дисков" и т.п. Для проверок из схемы автоматики тоже можно задать лимиты. В UI форма доступна сразу после включения схемы автоматики в проекте. В консольном клиенте можно задать лимиты таким образом:

`$ wall-e projects automation limits set $project --dns-fixes 1d:5 --ssh 2h:5 -o <check_name> 1d:10 -m "set limits for dns, ssh and <check_name>"`

Для dns-автоматики настраивается лимит на максимальное количество хостов, для которых исправлены dns-записи. Дополнительно существует лимит на количество хостов, которые перешли в статус dead.

Для каждого вида лимита можно задать несколько пар `период - количество`, для которых затем будут проверяться лимиты. В качестве периода используется строка вида `$number(s|m|h|d)`, суффикс которой указывает на единицу измерения (`s` - секунды, `m` - минуты, `h` - часы, `d` - дни).

Глобальные лимиты задаются в [конфигурационном файле Wall-E](../guide/general.md#service-config) в разделах `automation.{max_rebooted_hosts,max_profiled_hosts,max_redeployed_hosts,max_memory_changes,max_disk_changes,max_link_repairs,max_dns_fixes,max_dead_hosts}`. Если автоматика аварийно выключилась из-за глобальных лимитов, то включить обратно ее может только [пользователь с правами админа](../guide/authorization.md) (команда `wall-e settings set disable_automation false`).

{% note warning %}

Операции над хостами в состоянии `maintenance` и `probation` не потребляют лимиты на автоматику, так как такие хосты заведомо отличаются от хостов, находящихся в нормальной эксплуатации и блокировать очередь автопочинки из-за них не следует.

Если в проекте много хостов в состоянии `probation` и включена автоматика, есть вероятность, что Wall-E может отправить чиниться весь кластер разом.

{% endnote %}

Лимиты на уровне проекта задаются владельцами проектов. Включение автоматики после ее аварийного отключения для проекта - задача администраторов данного проекта. Поэтому крайне рекомендуется, чтобы в каждом проекте [email-нотификации](../guide/notifications.md) были настроены так, что сообщения с critical severity приходили хотя бы одному человеку, ответственному за данный проект.

По умолчанию лимиты в каждом проекте разрешают 10 срабатываний проверок каждого типа за один день.

{% note info %}

При каждом включении автоматики счетчики произведенных действий обнуляются (это самое простое решение проблемы "как сделать так, чтобы после включения автоматики она тут же не выключалась обратно").

{% endnote %}

## Кредиты на автоматические действия {#automation-credits}
В силу простоты алгоритма защиты от уничтожения кластера время от времени возникает следующая проблема: автоматика была выключена в течение какого-то времени (нескольких дней), и вы хотите ее включить, но за это время накопилось довольно большое количество сломанных машин, которое уже не влезает в отведенные лимиты, поэтому после включения автоматики у проекта тут же "перегорает предохранитель" и она снова аварийно отключается. Специально для такого случая есть возможность при включении автоматики дать Wall-E разрешение превысить лимиты в определенных пределах. К примеру, если мы включим автоматику командой `wall-e projects automation enable --credit-time 1h --unreachable 100 --ssh 100 $project`, то в течение следующего часа Wall-E будет лечить машины ребутом за счет выданных кредитов (100 срабатываний проверок) до тех пор, пока не израсходует эти кредиты, либо не истечет время кредита (1 час), после чего автоматика будет работать за счет стандартных лимитов, заданных для проекта.

Wall-E не проверяет количество автоматических операций, которые выполняются в данный момент. Т. е., теоретически, если Wall-E будет отправлять в переналивку по нескольку машин в день, которые по какой-либо причине будут висеть в наливке днями (к примеру, из-за замены тушек), то автоматика не выключится, и мы, пусть и очень медленно, будем уничтожать кластер. Предполагается, что данная проблема должна решаться на уровне [CMS](../cms/general.md).


## Если совсем плохо {#foxtrot-unicorn}
{% note warning %}

Если вдруг разработчики где-то накосячили так, что Wall-E пошел уничтожать кластер, несмотря на все ограничения и выключенную автоматику, то срочно звоните [админам](../guide/general.md#contacts) и просите выполнить [вот эти](../guide/general.md#how-to-kill-wall-e) действия.

{% endnote %}
